/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.awt.Point;
import java.util.Comparator;

public class Comparators {

    public static class PointDistanceComparator
    implements Comparator<Point> {
        private final Point target;

        public PointDistanceComparator(Point p) {
            this.target = p;
        }

        @Override
        public int compare(Point o1, Point o2) {
            return (int)Math.signum(ReikaMathLibrary.py3d(o1.x - this.target.x, 0.0, o1.y - this.target.y));
        }
    }

    public static class TaxicabCoordinateDistanceComparator
    implements Comparator<Coordinate> {
        private final Coordinate target;

        public TaxicabCoordinateDistanceComparator(Coordinate p) {
            this.target = p;
        }

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            return Integer.compare(o1.getTaxicabDistanceTo(this.target), o2.getTaxicabDistanceTo(this.target));
        }
    }

    public static class CoordinateDistanceComparator
    implements Comparator<Coordinate> {
        private final Coordinate target;

        public CoordinateDistanceComparator(Coordinate p) {
            this.target = p;
        }

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            return (int)Math.signum(ReikaMathLibrary.py3d(o1.xCoord - this.target.xCoord, o1.yCoord - this.target.yCoord, o1.zCoord - this.target.zCoord));
        }
    }
}

