/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Rendering.BasicFontRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public final class DelegateFontRenderer
extends FontRenderer {
    private final FontRenderer fallback;
    private final HashBiMap<String, BasicFontRenderer> renderers = HashBiMap.create();
    private static int currentID = 512;
    private static final int maxID = 65535;
    private static final char keyChar = '\ufffc';

    public DelegateFontRenderer(FontRenderer fr) {
        super(Minecraft.func_71410_x().field_71474_y, ReikaTextureHelper.font, Minecraft.func_71410_x().field_71446_o, false);
        this.fallback = fr;
        this.func_78264_a(fr.func_82883_a());
        this.func_78275_b(fr.func_78260_a());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_78264_a(boolean flag) {
        super.func_78264_a(flag);
        this.fallback.func_78264_a(flag);
    }

    public void func_78275_b(boolean flag) {
        super.func_78275_b(flag);
        this.fallback.func_78275_b(flag);
    }

    public String addRenderer(BasicFontRenderer f) {
        if (currentID >= 65535) {
            throw new MisuseException("Delegate Font Renderer has run out of IDs! All 65535 IDs occupied!");
        }
        String id = '\ufffc' + String.valueOf((char)currentID);
        this.renderers.put((Object)id, (Object)f);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)f);
        MinecraftForge.EVENT_BUS.register((Object)f);
        ++currentID;
        return id;
    }

    public int func_85187_a(String sg, int x, int y, int color, boolean shadow) {
        FontKey f = this.getRenderer(sg);
        if (f != null) {
            return f.renderer.func_85187_a(f.text, x, y, color, shadow);
        }
        return this.fallback.func_85187_a(sg, x, y, color, shadow);
    }

    public void func_78279_b(String sg, int x, int y, int space, int color) {
        FontKey f = this.getRenderer(sg);
        if (f != null) {
            f.renderer.func_78279_b(f.text, x, y, space, color);
        } else {
            this.fallback.func_78279_b(sg, x, y, space, color);
        }
    }

    private FontKey getRenderer(String sg) {
        String key;
        BasicFontRenderer f;
        int index;
        if (sg != null && sg.length() > 2 && (index = sg.indexOf(65532)) >= 0 && index < sg.length() - 1 && (f = (BasicFontRenderer)((Object)this.renderers.get((Object)(key = sg.substring(index, index + 2))))) != null) {
            return new FontKey(f, sg.substring(0, index) + sg.substring(index + 2, sg.length()));
        }
        return null;
    }

    public void func_110549_a(IResourceManager irm) {
        super.func_110549_a(irm);
    }

    public FontRenderer getFallback() {
        return this.fallback;
    }

    public static DelegateFontRenderer getRegisteredInstance() {
        if (!Loader.instance().hasReachedState(LoaderState.LOADING)) {
            throw new MisuseException("Tried to access the delegate font renderer too early!");
        }
        return (DelegateFontRenderer)Minecraft.func_71410_x().field_71466_p;
    }

    public static String stripFlags(String sg) {
        int idx = sg.indexOf(65532);
        while (idx >= 0) {
            sg = sg.replaceAll(String.valueOf('\ufffc') + String.valueOf(sg.charAt(idx + 1)), "");
            idx = sg.indexOf(65532);
        }
        return sg;
    }

    private static class FontKey {
        private final BasicFontRenderer renderer;
        private final String text;

        private FontKey(BasicFontRenderer f, String s) {
            this.renderer = f;
            this.text = s;
        }
    }
}

