/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI;

import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.UserSpecificConfig;

public enum DragonOptions implements IntegerConfig,
BooleanConfig,
StringArrayConfig,
UserSpecificConfig
{
    LOGLOADING("Console Loading Info", true),
    FILELOG("Log Loading Info To Separate File", false),
    DEBUGMODE("Debug Mode", false),
    SYNCPACKET("Sync Packet ID", 182),
    NORENDERS("Disable Renders For Debug", false),
    TABNBT("Show TileEntity NBT when using Debug Key", false),
    SOUNDCHANNELS("Increase sound channel count", true),
    UNNERFOBSIDIAN("Restore Obsidian Blast Resistance", true),
    NOHOTBARSWAP("Disable Hotbar Swapping", false),
    CHATERRORS("Log errors to chat", true),
    SORTCREATIVE("Sort Creative Tabs Alphabetically", true),
    CUSTOMRENDER("Custom/Donator Renders", true),
    OPONLYUPDATE("Only show update notice to Ops or SSP", false),
    PACKONLYUPDATE("Only show update notice to pack creator", false),
    GREGORES("Force Gregtech Ore Compatibility", true),
    LOGSYNCCME("Log Sync Packet CME Avoidance", true),
    SLOWSYNC("Slow Sync Packets - Only use this as a last resort", false),
    NONULLITEMS("Disallow Null-Item ItemStacks to Prevent Crashes", true),
    LAGWARNING("Minimum Delay (ms) for 'Can't Keep Up!' Log Warning", 0),
    CHECKSANITY("Check Environment Sanity", false),
    FIXSANITY("Attempt to Repair Environment Sanity", false),
    ADMINPERMBYPASS("Admins Bypass Permissions", true),
    SOUNDHASHMAP("Use HashMap for Sound Categories - Only use if necessary", false),
    FILEHASH("Compare mod file hashes between client and server", true),
    APRIL("Enable Temporally Dependent Amusement Behavior", true),
    NOALPHATEST("Disable Alpha Clipping in WorldRenderer", true),
    PARTICLELIMIT("Particle Limit (Vanilla = 4000)", 4000),
    DEBUGKEY("Debug Overlay Key (LWJGL ID)", 15),
    DIRECTOC("Direct OpenComputers Support", false),
    AUTOREBOOT("Automatic Reboot Interval (Seconds)", -1),
    XPMERGE("Merge XP Orbs Like Items", true),
    RAINTICK("Extra Block Ticks When Raining", true),
    PROTECTNEW("Prevent Mobs From Targeting Players Immediately After Logging In", true),
    SKINCACHE("Cache Skins", true),
    BIOMEFIRE("Biome Humidity Dependent Fire Spread", true),
    ADMINPROFILERS("Restrict profiling abilities to admins", true),
    BYTECODELIST("Bytecodeexec command user UUID whitelist", new String[0]);

    private String label;
    private boolean defaultState;
    private int defaultValue;
    private String defaultString;
    private String[] defaultStringArray;
    private Class type;
    private boolean enforcing = false;
    public static final DragonOptions[] optionList;

    private DragonOptions(String l, boolean d) {
        this.label = l;
        this.defaultState = d;
        this.type = Boolean.TYPE;
    }

    private DragonOptions(String l, boolean d, boolean tag) {
        this(l, d);
        this.enforcing = true;
    }

    private DragonOptions(String l, int d) {
        this.label = l;
        this.defaultValue = d;
        this.type = Integer.TYPE;
    }

    private DragonOptions(String l, String s) {
        this.label = l;
        this.defaultString = s;
        this.type = String.class;
    }

    private DragonOptions(String l, String[] s) {
        this.label = l;
        this.defaultStringArray = s;
        this.type = String[].class;
    }

    @Override
    public boolean isBoolean() {
        return this.type == Boolean.TYPE;
    }

    @Override
    public boolean isNumeric() {
        return this.type == Integer.TYPE;
    }

    public boolean isString() {
        return this.type == String.class;
    }

    @Override
    public Class getPropertyType() {
        return this.type;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean getState() {
        return (Boolean)DragonAPIInit.config.getControl(this.ordinal());
    }

    @Override
    public int getValue() {
        return (Integer)DragonAPIInit.config.getControl(this.ordinal());
    }

    public boolean isDummiedOut() {
        return this.type == null;
    }

    @Override
    public boolean getDefaultState() {
        return this.defaultState;
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isEnforcingDefaults() {
        return this.enforcing;
    }

    @Override
    public boolean shouldLoad() {
        return true;
    }

    @Override
    public boolean isUserSpecific() {
        switch (this) {
            case LOGLOADING: 
            case FILELOG: 
            case DEBUGMODE: 
            case NORENDERS: 
            case SOUNDCHANNELS: 
            case NOHOTBARSWAP: 
            case CHATERRORS: 
            case SORTCREATIVE: 
            case CUSTOMRENDER: 
            case APRIL: 
            case NOALPHATEST: 
            case TABNBT: 
            case PARTICLELIMIT: 
            case DEBUGKEY: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStringArray() {
        return this.type == String[].class;
    }

    @Override
    public String[] getStringArray() {
        return (String[])DragonAPIInit.config.getControl(this.ordinal());
    }

    @Override
    public String[] getDefaultStringArray() {
        return this.defaultStringArray;
    }

    static {
        optionList = DragonOptions.values();
    }
}

