/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Auxiliary.Trackers.EventProfiler;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;

public class EventProfilerCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length < 1) {
            EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Wrong number of arguments. Specify 'disable', 'enable', or 'display'.");
            return;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "disable": {
                EventProfiler.finishProfiling();
                EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Profiling finished.");
                break;
            }
            case "enable": {
                if (args.length < 2) {
                    EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "You must specify an event type (class)!");
                    return;
                }
                EventProfiler.ProfileStartStatus st = EventProfiler.startProfiling(args[1]);
                switch (st) {
                    case SUCCESS: {
                        EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Profiling started for events of type " + args[1]);
                        break;
                    }
                    case ALREADYRUNNING: {
                        EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Profiling already running!");
                        break;
                    }
                    case NOSUCHCLASS: {
                        EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "No such class '" + args[1] + "'!");
                        break;
                    }
                    case NOTANEVENT: {
                        EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Class '" + args[1] + "' does not extend Event!");
                    }
                }
                break;
            }
            case "display": {
                String type = EventProfiler.getProfiledEventType();
                ArrayList<EventProfiler.EventProfile> li = EventProfiler.getProfilingData();
                int fires = EventProfiler.getEventFireCount();
                long total = EventProfiler.getTotalProfilingTime();
                String totalt = String.format("%.6f", (double)total / 1000000.0);
                String desc = "Profiling data for event type " + type + " contains " + li.size() + " handlers across " + fires + " event fires, total time " + totalt + " ms:";
                EventProfilerCommand.sendChatToSender(ics, desc);
                DragonAPICore.log(desc);
                for (EventProfiler.EventProfile g : li) {
                    long time = g.getAverageTime();
                    String s = ReikaStringParser.padToLength("'" + g.identifier + "'", 60, " ");
                    double percent = (double)g.getTotalTime() * 100.0 / (double)total;
                    String sg = String.format("Handler %s - Average Time Per Fire: %7.3f microseconds (%2.3f%s)", s, (double)time / 1000.0, percent, "%%");
                    EventProfilerCommand.sendChatToSender(ics, sg);
                    DragonAPICore.log(sg);
                }
                break;
            }
            default: {
                EventProfilerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Invalid argument. Specify 'disable', 'enable', or 'display'.");
            }
        }
    }

    @Override
    public String getCommandString() {
        return "profileevent";
    }

    @Override
    protected boolean isAdminOnly() {
        return DragonOptions.ADMINPROFILERS.getState();
    }
}

