/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public class EntityListCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length != 1) {
            EntityListCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Invalid arguments. Use /" + this.getCommandString() + " <side>.");
            return;
        }
        Side side = null;
        try {
            side = Side.valueOf((String)args[0].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(EnumChatFormatting.RED + "Invalid side. Use one of the following: ");
            for (int i = 0; i < Side.values().length; ++i) {
                sb.append("'");
                sb.append(Side.values()[i].name().toLowerCase(Locale.ENGLISH));
                sb.append("'");
                if (i >= Side.values().length - 1) continue;
                sb.append(", ");
            }
            sb.append(".");
            EntityListCommand.sendChatToSender(ics, sb.toString());
            return;
        }
        EntityPlayerMP ep = EntityListCommand.func_71521_c((ICommandSender)ics);
        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, "Found entities:");
        this.perform(side, ep);
    }

    @Override
    public String getCommandString() {
        return "entitylist";
    }

    @Override
    protected boolean isAdminOnly() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void dumpClientside() {
        ArrayList<String> data = EntityListCommand.getData((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        for (String s : data) {
            ReikaChatHelper.writeString(s);
        }
    }

    private void perform(Side side, EntityPlayerMP ep) {
        switch (side) {
            case CLIENT: {
                this.sendPacket(ep);
                break;
            }
            case SERVER: {
                ArrayList<String> data = EntityListCommand.getData((EntityPlayer)ep, side);
                for (String s : data) {
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, s);
                }
                break;
            }
        }
    }

    private void sendPacket(EntityPlayerMP ep) {
        ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.ENTITYDUMP.ordinal(), ep, new int[0]);
    }

    private static ArrayList<String> getData(EntityPlayer ep, Side side) {
        ArrayList<String> li = new ArrayList<String>();
        String sd = ReikaStringParser.capFirstChar(side.name());
        for (Class c : EntityList.field_75626_c.keySet()) {
            String s = (String)EntityList.field_75626_c.get(c);
            if (s == null) {
                s = "[NO NAME]";
            } else if (s.isEmpty()) {
                s = "[EMPTY STRING]";
            }
            Integer id = (Integer)EntityList.field_75622_f.get(s);
            String sid = id != null ? String.valueOf(id) : "[NO ID]";
            String loc = ReikaEntityHelper.getEntityDisplayName(s);
            li.add(String.format("%s - '%s': Class = %s; ID = %s; Name = '%s'", sd, s, c.getName(), sid, loc));
        }
        return li;
    }
}

