/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Exception.WTFException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.ItemMaterial;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemMaterialController {
    private final ItemHashMap<ItemMaterial> data = new ItemHashMap();
    private final ArrayList<ItemStack> locks = new ArrayList();
    public static final ItemMaterialController instance = new ItemMaterialController();

    private ItemMaterialController() {
        this.addVanillaItem(Items.field_151013_M, ItemMaterial.GOLD);
        this.addVanillaItem(Items.field_151005_D, ItemMaterial.GOLD);
        this.addVanillaItem(Items.field_151011_C, ItemMaterial.GOLD);
        this.addVanillaItem(Items.field_151010_B, ItemMaterial.GOLD);
        this.addVanillaItem(Items.field_151006_E, ItemMaterial.GOLD);
        this.addVanillaItem(Blocks.field_150318_D, ItemMaterial.GOLD);
        this.addVanillaItem((Item)Items.field_151169_ag, ItemMaterial.GOLD);
        this.addVanillaItem((Item)Items.field_151151_aj, ItemMaterial.GOLD);
        this.addVanillaItem((Item)Items.field_151149_ai, ItemMaterial.GOLD);
        this.addVanillaItem((Item)Items.field_151171_ah, ItemMaterial.GOLD);
        this.addVanillaItem(Items.field_151019_K, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151035_b, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151037_a, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151040_l, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151036_c, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150319_E, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150448_aq, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150408_cc, ItemMaterial.IRON);
        this.addVanillaItem((Item)Items.field_151028_Y, ItemMaterial.IRON);
        this.addVanillaItem((Item)Items.field_151167_ab, ItemMaterial.IRON);
        this.addVanillaItem((Item)Items.field_151165_aa, ItemMaterial.IRON);
        this.addVanillaItem((Item)Items.field_151030_Z, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151033_d, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150411_aY, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151066_bu, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150467_bQ, ItemMaterial.IRON);
        this.addVanillaItem((Block)Blocks.field_150438_bZ, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151139_aw, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151133_ar, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151143_au, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150343_Z, ItemMaterial.OBSIDIAN);
        this.addVanillaItem(Blocks.field_150484_ah, ItemMaterial.DIAMOND);
        this.addVanillaItem(Blocks.field_150339_S, ItemMaterial.IRON);
        this.addVanillaItem(Blocks.field_150340_R, ItemMaterial.GOLD);
        this.addVanillaItem(Blocks.field_150348_b, ItemMaterial.STONE);
        this.addVanillaItem(Blocks.field_150347_e, ItemMaterial.STONE);
        this.addVanillaItem(Blocks.field_150417_aV, ItemMaterial.STONE);
        this.addVanillaItem(Blocks.field_150336_V, ItemMaterial.STONE);
        this.addVanillaItem(Blocks.field_150342_X, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151135_aq, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151155_ap, ItemMaterial.WOOD);
        this.addVanillaItem(Blocks.field_150462_ai, ItemMaterial.WOOD);
        this.addVanillaItem((Block)Blocks.field_150486_ae, ItemMaterial.WOOD);
        this.addVanillaItem(Blocks.field_150447_bR, ItemMaterial.WOOD);
        this.addVanillaItem(Blocks.field_150476_ad, ItemMaterial.WOOD);
        this.addVanillaItem(Blocks.field_150487_bG, ItemMaterial.WOOD);
        this.addVanillaItem(Blocks.field_150485_bF, ItemMaterial.WOOD);
        this.addVanillaItem(Blocks.field_150481_bH, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151055_y, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151054_z, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151041_m, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151039_o, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151053_p, ItemMaterial.WOOD);
        this.addVanillaItem(Items.field_151038_n, ItemMaterial.WOOD);
        for (int i = 0; i < 4; ++i) {
            this.addVanillaItem(new ItemStack(Blocks.field_150344_f, 1, i), ItemMaterial.WOOD);
            this.addVanillaItem(new ItemStack(Blocks.field_150364_r, 1, i), ItemMaterial.WOOD);
            this.addVanillaItem(new ItemStack(Blocks.field_150363_s, 1, i), ItemMaterial.WOOD);
        }
        this.addVanillaItem(Items.field_151045_i, ItemMaterial.DIAMOND);
        this.addVanillaItem(Items.field_151042_j, ItemMaterial.IRON);
        this.addVanillaItem(Items.field_151043_k, ItemMaterial.GOLD);
        this.addVanillaItem(Items.field_151044_h, ItemMaterial.COAL);
        this.addVanillaItem(new ItemStack(Items.field_151044_h, 1, 1), ItemMaterial.COAL);
        this.addVanillaItem(Blocks.field_150402_ci, ItemMaterial.COAL);
    }

    public void addItem(ItemStack is, ItemMaterial mat) {
        if (this.hasImmutableMapping(is)) {
            throw new MisuseException("Do not try to overwrite mappings of vanilla items!");
        }
        DragonAPICore.log("DRAGONAPI: Adding " + mat + " material properties to " + is);
        this.data.put(is, mat);
    }

    public void addItem(Item i, ItemMaterial mat) {
        this.addItem(new ItemStack(i), mat);
    }

    public void addItem(Block b, ItemMaterial mat) {
        this.addItem(new ItemStack(b), mat);
    }

    public boolean hasImmutableMapping(ItemStack is) {
        return ReikaItemHelper.collectionContainsItemStack(this.locks, is);
    }

    private void addVanillaItem(ItemStack is, ItemMaterial mat) {
        if (this.hasImmutableMapping(is)) {
            throw new MisuseException("Do not try to overwrite mappings of vanilla items!");
        }
        DragonAPICore.log("Adding immutable material " + mat + " properties to vanilla item " + is);
        this.data.put(is, mat);
        this.locks.add(is);
    }

    private void addVanillaItem(Item i, ItemMaterial mat) {
        if (i == null) {
            throw new WTFException("Some mod is deleting the vanilla item " + i + "!", true);
        }
        this.addVanillaItem(new ItemStack(i), mat);
    }

    private void addVanillaItem(Block b, ItemMaterial mat) {
        if (b == null) {
            throw new WTFException("Some mod is deleting the vanilla block " + b + "!", true);
        }
        if (Item.func_150898_a((Block)b) == null) {
            DragonAPICore.logError("Block " + b + " has no corresponding item!");
        } else {
            this.addVanillaItem(new ItemStack(b), mat);
        }
    }

    public int getMeltingPoint(ItemStack is) {
        if (!this.hasDataFor(is)) {
            return 0;
        }
        return this.data.get(is).getMelting();
    }

    public boolean hasDataFor(ItemStack is) {
        return this.data.containsKey(is);
    }

    public ItemMaterial getMaterial(ItemStack is) {
        return this.data.get(is);
    }
}

