/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.ModList;
import net.minecraft.world.biome.BiomeGenBase;

public enum BiomeTypeList {
    OCEAN(BiomeGenBase.field_76771_b, BiomeGenBase.field_76776_l),
    PLAINS(BiomeGenBase.field_76772_c),
    DESERT(BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s),
    MOUNTAIN(BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v),
    FOREST(BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t),
    TAIGA(BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u),
    SWAMP(BiomeGenBase.field_76780_h),
    RIVER(BiomeGenBase.field_76781_i, BiomeGenBase.field_76777_m, BiomeGenBase.field_76787_r),
    ARCTIC(BiomeGenBase.field_76774_n, BiomeGenBase.field_76775_o),
    MUSHROOM(BiomeGenBase.field_76789_p, BiomeGenBase.field_76788_q),
    JUNGLE(BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x),
    RAINBOW("Rainbow Forest", ModList.CHROMATICRAFT, "Reika.ChromatiCraft.World.BiomeRainbowForest"),
    ENDER("Ender Forest", ModList.CHROMATICRAFT, "Reika.ChromatiCraft.World.BiomeEnderForest"),
    GLOWCLIFFS("Luminous Cliffs", ModList.CHROMATICRAFT, "Reika.ChromatiCraft.World.BiomeGlowingCliffs");

    private String[] biomes;
    private ModList dependency;
    public final String displayName;
    public static final BiomeTypeList[] biomeList;

    private BiomeTypeList(BiomeGenBase ... biomes) {
        this.biomes = new String[biomes.length];
        for (int i = 0; i < biomes.length; ++i) {
            this.biomes[i] = biomes[i].getClass().getCanonicalName();
        }
        this.displayName = biomes[0].field_76791_y;
    }

    private BiomeTypeList(String name, ModList mod, String ... biomes) {
        this.dependency = mod;
        if (!this.dependency.isLoaded()) {
            this.displayName = name + " (Unloaded)";
            return;
        }
        this.biomes = biomes;
        this.displayName = name;
    }

    public boolean isAvailable() {
        return this.dependency != null ? this.dependency.isLoaded() : true;
    }

    public static BiomeTypeList getEntry(BiomeGenBase biome) {
        if (biome == null) {
            DragonAPIInit.instance.getModLogger().log("Null Biome!");
            return null;
        }
        String name = biome.getClass().getCanonicalName();
        name = biome.getClass().getCanonicalName() == null && biome.getClass().getEnclosingClass() != null ? biome.getClass().getEnclosingClass().getCanonicalName() : biome.getClass().getCanonicalName();
        for (int i = 0; i < biomeList.length; ++i) {
            BiomeTypeList type = biomeList[i];
            if (!type.isAvailable()) continue;
            String[] biomes = type.biomes;
            for (int j = 0; j < biomes.length; ++j) {
                if (!name.equals(biomes[j])) continue;
                return biomeList[i];
            }
        }
        return null;
    }

    static {
        biomeList = BiomeTypeList.values();
    }
}

