/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Profiling;

import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Interfaces.Subgenerator;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MapGeneratorProfilingHooks
implements IClassTransformer {
    private final HashSet<String> superClasses = new HashSet();

    public MapGeneratorProfilingHooks() {
        this.superClasses.add("net/minecraft/world/gen/MapGenBase");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode cn = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)cn, 0);
        if (this.superClasses.contains(cn.superName) && !cn.interfaces.contains(Subgenerator.class.getName().replace(".", "/"))) {
            ReikaASMHelper.activeMod = "DragonAPI";
            try {
                ReikaASMHelper.activeMod = "DragonAPI";
                MethodNode m = ReikaASMHelper.getMethodByName(cn, "func_151538_a", "func_151538_a", "(Lnet/minecraft/world/World;IIII[Lnet/minecraft/block/Block;)V");
                ArrayList<AbstractInsnNode> c = new ArrayList<AbstractInsnNode>();
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode ain = m.instructions.get(i);
                    if (ain.getOpcode() != 177) continue;
                    c.add(ain);
                }
                this.inject(m, m.instructions.getFirst(), true);
                for (AbstractInsnNode ain : c) {
                    this.inject(m, ain, false);
                }
                ReikaASMHelper.log("Injected " + (c.size() + 1) + " profiling hooks into " + cn.name);
            }
            catch (ASMException.NoSuchASMMethodException e) {
                ReikaASMHelper.log("Skipping profiling hooks on " + cn.name + "; does not contain generate method");
            }
            ReikaASMHelper.activeMod = null;
        }
        ClassWriter writer = new ClassWriter(1);
        cn.accept((ClassVisitor)writer);
        cn.check(cn.version);
        return writer.toByteArray();
    }

    private void inject(MethodNode m, AbstractInsnNode ain, boolean isPre) {
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(25, 1));
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new VarInsnNode(21, 4));
        li.add((AbstractInsnNode)new VarInsnNode(21, 5));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Auxiliary/Trackers/WorldgenProfiler", isPre ? "startGenerator" : "onRunGenerator", "(Lnet/minecraft/world/World;Lnet/minecraft/world/gen/MapGenBase;II)V", false));
        m.instructions.insertBefore(ain, li);
    }
}

