/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.computers;

import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import com.brandon3055.draconicevolution.integration.computers.cc.CCAdapter;
import com.brandon3055.draconicevolution.integration.computers.oc.DEManagedPeripheral;
import com.brandon3055.draconicevolution.integration.computers.oc.IExtendedRFStoragePeripheral;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class CCOCIntegration {
    public static void init() {
        if (Loader.isModLoaded((String)"computercraft")) {
            CCOCIntegration.initCC();
        }
        if (Loader.isModLoaded((String)"opencomputers")) {
            CCOCIntegration.initOC();
        }
    }

    @Optional.Method(modid="computercraft")
    public static void initCC() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new DEPeripheralProvider());
    }

    @Optional.Method(modid="opencomputers")
    public static void initOC() {
        Driver.add((DriverBlock)new OCAdapter());
        Driver.add((DriverBlock)new OCExtendedRFAdapter());
    }

    public static class DEPeripheralProvider
    implements IPeripheralProvider {
        @Nullable
        public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IDEPeripheral) {
                return new CCAdapter((IDEPeripheral)tile);
            }
            return null;
        }
    }

    public static class OCExtendedRFAdapter
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return IExtendedRFStorage.class;
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
            return new IExtendedRFStoragePeripheral((IExtendedRFStorage)world.func_175625_s(pos));
        }
    }

    public static class OCAdapter
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return IDEPeripheral.class;
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
            return new DEManagedPeripheral((IDEPeripheral)world.func_175625_s(pos));
        }
    }
}

