/*
 * Decompiled with CFR 0.152.
 */
package com.knoxhack.densemetals.world;

import com.google.common.base.Predicate;
import com.knoxhack.densemetals.Config;
import com.knoxhack.densemetals.init.ModBlocks;
import com.mcmoddev.lib.init.Materials;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;

public class WorldGen
implements IWorldGenerator {
    private WorldGenerator denseIronOre = this.getWGM((Block)ModBlocks.denseIronBlock, Blocks.field_150366_p);
    private WorldGenerator denseDiamonBlock = this.getWGM((Block)ModBlocks.denseDiamonBlock, Blocks.field_150482_ag);
    private WorldGenerator denseRedstoneBlock = this.getWGM((Block)ModBlocks.denseRedstoneBlock, Blocks.field_150450_ax);
    private WorldGenerator denseEmeraldBlock = this.getWGM((Block)ModBlocks.denseEmeraldBlock, Blocks.field_150412_bA);
    private WorldGenerator denseCoalBlock = this.getWGM(ModBlocks.denseCoalBlock, 30, Blocks.field_150365_q);
    private WorldGenerator denseLapisBlock = this.getWGM((Block)ModBlocks.denseLapisBlock, Blocks.field_150369_x);
    private WorldGenerator denseGoldBlock = this.getWGM((Block)ModBlocks.denseGoldBlock, Blocks.field_150352_o);
    private WorldGenerator denseAdamantineBlock;
    private WorldGenerator denseAntimonyBlock;
    private WorldGenerator denseBismuthBlock;
    private WorldGenerator denseCopperBlock;
    private WorldGenerator denseColdironBlock;
    private WorldGenerator denseLeadBlock;
    private WorldGenerator denseNickelBlock;
    private WorldGenerator denseMercuryBlock;
    private WorldGenerator denseStarsteelBlock;
    private WorldGenerator denseTinBlock;
    private WorldGenerator denseZincBlock;

    public WorldGen() {
        if (Loader.isModLoaded((String)"basemetals") && Config.enabledBaseMetalsDenseOres) {
            this.denseAdamantineBlock = this.getWGM((Block)ModBlocks.denseAdamantineBlock, "adamntine");
            this.denseAntimonyBlock = this.getWGM((Block)ModBlocks.denseAntimonyBlock, "antimony");
            this.denseBismuthBlock = this.getWGM((Block)ModBlocks.denseBismuthBlock, "bismuth");
            this.denseCopperBlock = this.getWGM((Block)ModBlocks.denseCopperBlock, "copper");
            this.denseColdironBlock = this.getWGM((Block)ModBlocks.denseColdironBlock, "coldiron");
            this.denseLeadBlock = this.getWGM((Block)ModBlocks.denseLeadBlock, "lead");
            this.denseNickelBlock = this.getWGM((Block)ModBlocks.denseNickelBlock, "nickel");
            this.denseMercuryBlock = this.getWGM((Block)ModBlocks.denseMercuryBlock, "mercury");
            this.denseStarsteelBlock = this.getWGM((Block)ModBlocks.denseStarsteelBlock, "starsteel");
            this.denseTinBlock = this.getWGM((Block)ModBlocks.denseTinBlock, "tin");
            this.denseZincBlock = this.getWGM((Block)ModBlocks.denseZincBlock, "zinc");
        }
    }

    private WorldGenMinable getWGM(Block block, int count, Block blockType) {
        return new WorldGenMinable(block.func_176223_P(), count, (Predicate)BlockMatcher.func_177642_a((Block)blockType));
    }

    private WorldGenMinable getWGM(Block block, Block blockType) {
        return this.getWGM(block, 35, blockType);
    }

    private WorldGenMinable getWGM(Block block, String name) {
        return this.getWGM(block, 35, Materials.getMaterialByName((String)name).getBlock("ore"));
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (!Config.enabledInternalWorldGen) break;
                if (Config.enabledVanillaDenseOres) {
                    if (Config.enabledDenseIronOre) {
                        this.runGenerator(this.denseIronOre, world, random, chunkX, chunkZ, 20, 0, 96);
                    }
                    if (Config.enabledDenseDiamondOre) {
                        this.runGenerator(this.denseDiamonBlock, world, random, chunkX, chunkZ, 30, 0, 30);
                    }
                    if (Config.enabledDenseRedstoneOre) {
                        this.runGenerator(this.denseRedstoneBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                    if (Config.enabledDenseEmeraldOre) {
                        this.runGenerator(this.denseEmeraldBlock, world, random, chunkX, chunkZ, 30, 0, 96);
                    }
                    if (Config.enabledDenseCoalOre) {
                        this.runGenerator(this.denseCoalBlock, world, random, chunkX, chunkZ, 20, 0, 96);
                    }
                    if (Config.enabledDenseLapisOre) {
                        this.runGenerator(this.denseLapisBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                    if (Config.enabledDenseGoldOre) {
                        this.runGenerator(this.denseGoldBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                }
                if (!Config.enabledInternalWorldGen || !Loader.isModLoaded((String)"basemetals") || !Config.enabledBaseMetalsDenseOres) break;
                this.runGenerator(this.denseAntimonyBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseBismuthBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseCopperBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseLeadBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseNickelBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseMercuryBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseTinBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseZincBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                break;
            }
            case 6: {
                if (!Config.enabledInternalWorldGen) break;
                if (Config.enabledVanillaDenseOres) {
                    if (Config.enabledDenseIronOre) {
                        this.runGenerator(this.denseIronOre, world, random, chunkX, chunkZ, 20, 0, 120);
                    }
                    if (Config.enabledDenseDiamondOre) {
                        this.runGenerator(this.denseDiamonBlock, world, random, chunkX, chunkZ, 30, 0, 30);
                    }
                    if (Config.enabledDenseRedstoneOre) {
                        this.runGenerator(this.denseRedstoneBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                    if (Config.enabledDenseEmeraldOre) {
                        this.runGenerator(this.denseEmeraldBlock, world, random, chunkX, chunkZ, 30, 0, 100);
                    }
                    if (Config.enabledDenseCoalOre) {
                        this.runGenerator(this.denseCoalBlock, world, random, chunkX, chunkZ, 20, 0, 120);
                    }
                    if (Config.enabledDenseLapisOre) {
                        this.runGenerator(this.denseLapisBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                    if (Config.enabledDenseGoldOre) {
                        this.runGenerator(this.denseGoldBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                }
                if (!Config.enabledInternalWorldGen || !Loader.isModLoaded((String)"basemetals") || !Config.enabledBaseMetalsDenseOres) break;
                this.runGenerator(this.denseAntimonyBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseBismuthBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseCopperBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseLeadBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseNickelBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseMercuryBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseTinBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseZincBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                break;
            }
            case 69: {
                if (!Config.enabledInternalWorldGen) break;
                if (Config.enabledVanillaDenseOres) {
                    if (Config.enabledDenseIronOre) {
                        this.runGenerator(this.denseIronOre, world, random, chunkX, chunkZ, 20, 0, 120);
                    }
                    if (Config.enabledDenseDiamondOre) {
                        this.runGenerator(this.denseDiamonBlock, world, random, chunkX, chunkZ, 30, 0, 30);
                    }
                    if (Config.enabledDenseRedstoneOre) {
                        this.runGenerator(this.denseRedstoneBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                    if (Config.enabledDenseEmeraldOre) {
                        this.runGenerator(this.denseEmeraldBlock, world, random, chunkX, chunkZ, 30, 0, 100);
                    }
                    if (Config.enabledDenseCoalOre) {
                        this.runGenerator(this.denseCoalBlock, world, random, chunkX, chunkZ, 20, 0, 120);
                    }
                    if (Config.enabledDenseLapisOre) {
                        this.runGenerator(this.denseLapisBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                    if (Config.enabledDenseGoldOre) {
                        this.runGenerator(this.denseGoldBlock, world, random, chunkX, chunkZ, 30, 0, 35);
                    }
                }
                if (!Config.enabledInternalWorldGen || !Loader.isModLoaded((String)"basemetals") || !Config.enabledBaseMetalsDenseOres) break;
                this.runGenerator(this.denseAntimonyBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseBismuthBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseCopperBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseLeadBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseNickelBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseMercuryBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseTinBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseZincBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                break;
            }
            case -1: {
                if (!Config.enabledInternalWorldGen || !Loader.isModLoaded((String)"basemetals") || !Config.enabledBaseMetalsDenseOres) break;
                this.runGenerator(this.denseAdamantineBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                this.runGenerator(this.denseColdironBlock, world, random, chunkX, chunkZ, 100, 0, 96);
                break;
            }
            case 1: {
                if (!Config.enabledInternalWorldGen || !Loader.isModLoaded((String)"basemetals") || !Config.enabledBaseMetalsDenseOres) break;
                this.runGenerator(this.denseStarsteelBlock, world, random, chunkX, chunkZ, 100, 0, 96);
            }
        }
    }
}

