/*
 * Decompiled with CFR 0.152.
 */
package com.knoxhack.densemetals.init;

import com.google.common.base.Preconditions;
import com.knoxhack.densemetals.Config;
import com.knoxhack.densemetals.blocks.BlockBase;
import com.knoxhack.densemetals.blocks.BlockBaseModded;
import com.knoxhack.densemetals.blocks.BlockBaseModdedNether;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="densemetals")
public class ModBlocks {
    public static final BlockBase denseIronBlock = new BlockBase(Material.field_151573_f, "dense_iron_ore", Blocks.field_150366_p);
    public static final BlockBase denseDiamonBlock = new BlockBase(Material.field_151573_f, "dense_diamond_ore", Items.field_151045_i);
    public static final BlockBase denseRedstoneBlock = new BlockBase(Material.field_151573_f, "dense_redstone_ore", Items.field_151137_ax);
    public static final BlockBase denseEmeraldBlock = new BlockBase(Material.field_151573_f, "dense_emerald_ore", Items.field_151166_bC);
    public static final BlockBase denseCoalBlock = new BlockBase(Material.field_151573_f, "dense_coal_ore", Items.field_151044_h);
    public static final BlockBase denseLapisBlock = new BlockBase(Material.field_151573_f, "dense_lapis_ore", Items.field_151100_aR);
    public static final BlockBase denseGoldBlock = new BlockBase(Material.field_151573_f, "dense_gold_ore", Blocks.field_150352_o);
    public static final BlockBaseModded denseAdamantineBlock = new BlockBaseModded(Material.field_151573_f, "dense_adamantine_ore", "adamantine");
    public static final BlockBaseModded denseAntimonyBlock = new BlockBaseModded(Material.field_151573_f, "dense_antimony_ore", "antimony");
    public static final BlockBaseModded denseBismuthBlock = new BlockBaseModded(Material.field_151573_f, "dense_bismuth_ore", "bismuth");
    public static final BlockBaseModded denseCopperBlock = new BlockBaseModded(Material.field_151573_f, "dense_copper_ore", "copper");
    public static final BlockBaseModded denseColdironBlock = new BlockBaseModded(Material.field_151573_f, "dense_coldiron_ore", "coldiron");
    public static final BlockBaseModded denseLeadBlock = new BlockBaseModded(Material.field_151573_f, "dense_lead_ore", "lead");
    public static final BlockBaseModded denseNickelBlock = new BlockBaseModded(Material.field_151573_f, "dense_nickel_ore", "nickel");
    public static final BlockBaseModded denseMercuryBlock = new BlockBaseModded(Material.field_151573_f, "dense_mercury_ore", "mercury");
    public static final BlockBaseModded denseStarsteelBlock = new BlockBaseModded(Material.field_151573_f, "dense_starsteel_ore", "starsteel");
    public static final BlockBaseModded denseTinBlock = new BlockBaseModded(Material.field_151573_f, "dense_tin_ore", "tin");
    public static final BlockBaseModded denseZincBlock = new BlockBaseModded(Material.field_151573_f, "dense_zinc_ore", "zinc");
    public static final BlockBaseModdedNether denseNetherGoldBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_gold_ore", "gold");
    public static final BlockBaseModdedNether denseNetherLapisBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_lapis_ore", "lapis");
    public static final BlockBaseModdedNether denseNetherCoalBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_coal_ore", "coal");
    public static final BlockBaseModdedNether denseNetherEmeraldBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_emerald_ore", "emerald");
    public static final BlockBaseModdedNether denseNetherRedstoneBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_redstone_ore", "redstone");
    public static final BlockBaseModdedNether denseNetherDiamonBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_diamond_ore", "diamond");
    public static final BlockBaseModdedNether denseNetherIronBlock = new BlockBaseModdedNether(Material.field_151573_f, "dense_nether_iron_ore", "iron");

    public static void initBaseMetalsModels() {
        if (Loader.isModLoaded((String)"basemetals") && Config.enabledNetherMetalsDenseOres) {
            denseAdamantineBlock.initModel();
            denseAntimonyBlock.initModel();
            denseBismuthBlock.initModel();
            denseCopperBlock.initModel();
            denseColdironBlock.initModel();
            denseNickelBlock.initModel();
            denseMercuryBlock.initModel();
            denseStarsteelBlock.initModel();
            denseTinBlock.initModel();
            denseZincBlock.initModel();
            denseLeadBlock.initModel();
        }
    }

    public static void initNetherMetalsModels() {
        if (Loader.isModLoaded((String)"nethermetals") && Config.enabledBaseMetalsDenseOres) {
            denseNetherGoldBlock.initModel();
            denseNetherLapisBlock.initModel();
            denseNetherCoalBlock.initModel();
            denseNetherEmeraldBlock.initModel();
            denseNetherRedstoneBlock.initModel();
            denseNetherDiamonBlock.initModel();
            denseNetherIronBlock.initModel();
        }
    }

    public static void initVanillaModels() {
        if (Config.enabledVanillaDenseOres) {
            denseIronBlock.initModel();
            denseDiamonBlock.initModel();
            denseRedstoneBlock.initModel();
            denseEmeraldBlock.initModel();
            denseCoalBlock.initModel();
            denseLapisBlock.initModel();
            denseGoldBlock.initModel();
        }
    }

    @Mod.EventBusSubscriber(modid="densemetals")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBaseMetalsBlocks(RegistryEvent.Register<Block> event) {
            if (Loader.isModLoaded((String)"basemetals") && Config.enabledBaseMetalsDenseOres) {
                event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{denseAdamantineBlock, denseAntimonyBlock, denseBismuthBlock, denseCopperBlock, denseColdironBlock, denseLeadBlock, denseNickelBlock, denseMercuryBlock, denseStarsteelBlock, denseTinBlock, denseZincBlock});
            }
        }

        @SubscribeEvent
        public static void registerNetherMetalsVanillaBlocks(RegistryEvent.Register<Block> event) {
            if (Loader.isModLoaded((String)"nethermetals") && Config.enabledNetherMetalsDenseOres) {
                event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{denseNetherGoldBlock, denseNetherLapisBlock, denseNetherCoalBlock, denseNetherEmeraldBlock, denseNetherRedstoneBlock, denseNetherDiamonBlock, denseNetherIronBlock});
            }
        }

        @SubscribeEvent
        public static void registerVanillaBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            Block[] blocks = new Block[]{denseIronBlock, denseDiamonBlock, denseRedstoneBlock, denseEmeraldBlock, denseCoalBlock, denseLapisBlock, denseGoldBlock};
            if (Config.enabledVanillaDenseOres) {
                registry.registerAll((IForgeRegistryEntry[])blocks);
            }
        }

        @SubscribeEvent
        public static void registerBaseMetalsItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)denseAdamantineBlock), new ItemBlock((Block)denseAntimonyBlock), new ItemBlock((Block)denseBismuthBlock), new ItemBlock((Block)denseCopperBlock), new ItemBlock((Block)denseColdironBlock), new ItemBlock((Block)denseNickelBlock), new ItemBlock((Block)denseMercuryBlock), new ItemBlock((Block)denseStarsteelBlock), new ItemBlock((Block)denseTinBlock), new ItemBlock((Block)denseZincBlock), new ItemBlock((Block)denseLeadBlock)};
            if (Loader.isModLoaded((String)"basemetals") && Config.enabledBaseMetalsDenseOres) {
                IForgeRegistry registry = event.getRegistry();
                for (ItemBlock item : items) {
                    Block block = item.func_179223_d();
                    ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                    registry.register(item.setRegistryName(registryName));
                }
            }
        }

        @SubscribeEvent
        public static void registerNetherMetalsVanillaItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)denseNetherGoldBlock), new ItemBlock((Block)denseNetherLapisBlock), new ItemBlock((Block)denseNetherCoalBlock), new ItemBlock((Block)denseNetherEmeraldBlock), new ItemBlock((Block)denseNetherRedstoneBlock), new ItemBlock((Block)denseNetherDiamonBlock), new ItemBlock((Block)denseNetherIronBlock)};
            if (Loader.isModLoaded((String)"nethermetals") && Config.enabledNetherMetalsDenseOres) {
                IForgeRegistry registry = event.getRegistry();
                for (ItemBlock item : items) {
                    Block block = item.func_179223_d();
                    ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                    registry.register(item.setRegistryName(registryName));
                }
            }
        }

        @SubscribeEvent
        public static void registerVanillaItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)denseIronBlock), new ItemBlock((Block)denseDiamonBlock), new ItemBlock((Block)denseRedstoneBlock), new ItemBlock((Block)denseEmeraldBlock), new ItemBlock((Block)denseCoalBlock), new ItemBlock((Block)denseLapisBlock), new ItemBlock((Block)denseGoldBlock)};
            if (Config.enabledVanillaDenseOres) {
                IForgeRegistry registry = event.getRegistry();
                for (ItemBlock item : items) {
                    Block block = item.func_179223_d();
                    ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                    registry.register(item.setRegistryName(registryName));
                }
            }
        }
    }
}

