/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.configuration;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import drzhark.customspawner.configuration.CMSConfigCategory;
import drzhark.customspawner.configuration.CMSProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class CMSConfiguration {
    public static final String CATEGORY_GENERAL = "general";
    public static final String ALLOWED_CHARS = "._-";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CATEGORY_SPLITTER = ".";
    public static final String NEW_LINE;
    private static final Pattern CONFIG_START;
    private static final Pattern CONFIG_END;
    public static final CharMatcher allowedProperties;
    private static CMSConfiguration PARENT;
    public File file;
    public Map<String, CMSConfigCategory> categories = new TreeMap<String, CMSConfigCategory>();
    private Map<String, CMSConfiguration> children = new TreeMap<String, CMSConfiguration>();
    private boolean caseSensitiveCustomCategories;
    public String defaultEncoding = "UTF-8";
    private String fileName = null;
    public boolean isChild = false;
    private boolean changed = false;

    public CMSConfiguration() {
    }

    public CMSConfiguration(File file) {
        this.file = file;
        String basePath = ((File)FMLInjectionData.data()[6]).getAbsolutePath().replace(File.separatorChar, '/').replace("/.", "");
        String path = file.getAbsolutePath().replace(File.separatorChar, '/').replace("/./", "/").replace(basePath, "");
        if (PARENT != null) {
            PARENT.setChild(path, this);
            this.isChild = true;
        } else {
            this.fileName = path;
            this.load();
        }
    }

    public CMSConfiguration(File file, boolean caseSensitiveCustomCategories) {
        this(file);
        this.caseSensitiveCustomCategories = caseSensitiveCustomCategories;
    }

    public CMSConfiguration(File file, boolean caseSensitiveCustomCategories, boolean useNewLine) {
        this(file);
    }

    public CMSProperty get(String category, String key) {
        CMSConfigCategory cat = this.getCategory(category);
        if (cat.containsKey(key)) {
            CMSProperty prop = cat.get(key);
            return prop;
        }
        return null;
    }

    public CMSProperty get(String category, String key, int defaultValue) {
        return this.get(category, key, defaultValue, (String)null);
    }

    public CMSProperty get(String category, String key, int defaultValue, String comment) {
        CMSProperty prop = this.get(category, key, Integer.toString(defaultValue), comment, CMSProperty.Type.INTEGER);
        if (!prop.isIntValue()) {
            prop.set(defaultValue);
        }
        return prop;
    }

    public CMSProperty get(String category, String key, boolean defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public CMSProperty get(String category, String key, boolean defaultValue, String comment) {
        CMSProperty prop = this.get(category, key, Boolean.toString(defaultValue), comment, CMSProperty.Type.BOOLEAN);
        if (!prop.isBooleanValue()) {
            prop.set(defaultValue);
        }
        return prop;
    }

    public CMSProperty get(String category, String key, double defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public CMSProperty get(String category, String key, double defaultValue, String comment) {
        CMSProperty prop = this.get(category, key, Double.toString(defaultValue), comment, CMSProperty.Type.DOUBLE);
        if (!prop.isDoubleValue()) {
            prop.set(defaultValue);
        }
        return prop;
    }

    public CMSProperty get(String category, String key, String defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public CMSProperty get(String category, String key, String defaultValue, String comment) {
        return this.get(category, key, defaultValue, comment, CMSProperty.Type.STRING);
    }

    public CMSProperty get(String category, String key, List<String> defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public CMSProperty get(String category, String key, List<String> defaultValue, String comment) {
        return this.get(category, key, defaultValue, comment, CMSProperty.Type.STRING);
    }

    public CMSProperty get(String category, String key, int[] defaultValue) {
        return this.get(category, key, defaultValue, (String)null);
    }

    public CMSProperty get(String category, String key, int[] defaultValue, String comment) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < defaultValue.length; ++i) {
            values.add(Integer.toString(defaultValue[i]));
        }
        CMSProperty prop = this.get(category, key, values, comment, CMSProperty.Type.INTEGER);
        if (!prop.isIntList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public CMSProperty get(String category, String key, double[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public CMSProperty get(String category, String key, double[] defaultValue, String comment) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < defaultValue.length; ++i) {
            values.add(Double.toString(defaultValue[i]));
        }
        CMSProperty prop = this.get(category, key, values, comment, CMSProperty.Type.DOUBLE);
        if (!prop.isDoubleList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public CMSProperty get(String category, String key, boolean[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public CMSProperty get(String category, String key, boolean[] defaultValue, String comment) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < defaultValue.length; ++i) {
            values.add(Boolean.toString(defaultValue[i]));
        }
        CMSProperty prop = this.get(category, key, values, comment, CMSProperty.Type.BOOLEAN);
        if (!prop.isBooleanList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public CMSProperty get(String category, String key, String defaultValue, String comment, CMSProperty.Type type) {
        CMSConfigCategory cat;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((cat = this.getCategory(category)).containsKey(key)) {
            CMSProperty prop = cat.get(key);
            if (prop.getType() == null) {
                prop = new CMSProperty(prop.getName(), prop.value, type);
                cat.set(key, prop);
            }
            prop.comment = comment;
            return prop;
        }
        if (defaultValue != null) {
            CMSProperty prop = new CMSProperty(key, defaultValue, type);
            prop.set(defaultValue);
            cat.put(key, prop);
            prop.comment = comment;
            return prop;
        }
        return null;
    }

    public CMSProperty get(String category, String key, List<String> defaultValue, String comment, CMSProperty.Type type) {
        CMSConfigCategory cat;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((cat = this.getCategory(category)).containsKey(key)) {
            CMSProperty prop = cat.get(key);
            if (prop.getType() == null) {
                prop = new CMSProperty(prop.getName(), prop.getString(), type);
                cat.put(key, prop);
            }
            prop.comment = comment;
            return prop;
        }
        if (defaultValue != null) {
            CMSProperty prop = new CMSProperty(key, defaultValue, type);
            prop.comment = comment;
            cat.put(key, prop);
            return prop;
        }
        return null;
    }

    public boolean hasCategory(String category) {
        return this.categories.get(category) != null;
    }

    public boolean hasKey(String category, String key) {
        CMSConfigCategory cat = this.categories.get(category);
        return cat != null && cat.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block58: {
            if (PARENT != null && PARENT != this) {
                return;
            }
            BufferedReader buffer = null;
            UnicodeInputStreamReader input = null;
            try {
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                if (!this.file.exists() && !this.file.createNewFile()) {
                    return;
                }
                if (!this.file.canRead()) break block58;
                input = new UnicodeInputStreamReader(new FileInputStream(this.file), this.defaultEncoding);
                this.defaultEncoding = input.getEncoding();
                buffer = new BufferedReader(input);
                CMSConfigCategory currentCat = null;
                CMSProperty.Type type = null;
                ArrayList<String> tmpList = null;
                int lineNum = 0;
                String name = null;
                while (true) {
                    ++lineNum;
                    String line = buffer.readLine();
                    if (line == null) {
                        break;
                    }
                    Matcher start = CONFIG_START.matcher(line);
                    Matcher end = CONFIG_END.matcher(line);
                    if (start.matches()) {
                        this.fileName = start.group(1);
                        this.categories = new TreeMap<String, CMSConfigCategory>();
                        continue;
                    }
                    if (end.matches()) {
                        this.fileName = end.group(1);
                        CMSConfiguration child = new CMSConfiguration();
                        child.categories = this.categories;
                        this.children.put(this.fileName, child);
                        continue;
                    }
                    int nameStart = -1;
                    int nameEnd = -1;
                    boolean skip = false;
                    boolean quoted = false;
                    block33: for (int i = 0; i < line.length() && !skip; ++i) {
                        if (Character.isLetterOrDigit(line.charAt(i)) || ALLOWED_CHARS.indexOf(line.charAt(i)) != -1 || quoted && line.charAt(i) != '\"') {
                            if (nameStart == -1) {
                                nameStart = i;
                            }
                            nameEnd = i;
                            continue;
                        }
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        switch (line.charAt(i)) {
                            case '#': {
                                skip = true;
                                continue block33;
                            }
                            case '\"': {
                                if (quoted) {
                                    quoted = false;
                                }
                                if (quoted || nameStart != -1) continue block33;
                                quoted = true;
                                continue block33;
                            }
                            case '{': {
                                name = line.substring(nameStart, nameEnd + 1);
                                String qualifiedName = CMSConfigCategory.getQualifiedName(name, currentCat);
                                CMSConfigCategory cat = this.categories.get(qualifiedName);
                                if (cat == null) {
                                    currentCat = new CMSConfigCategory(name, currentCat);
                                    this.categories.put(qualifiedName, currentCat);
                                } else {
                                    currentCat = cat;
                                }
                                name = null;
                                continue block33;
                            }
                            case '}': {
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("Config file corrupt, attepted to close to many categories '%s:%d'", this.fileName, lineNum));
                                }
                                currentCat = currentCat.parent;
                                continue block33;
                            }
                            case '=': {
                                name = line.substring(nameStart, nameEnd + 1);
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("'%s' has no scope in '%s:%d'", name, this.fileName, lineNum));
                                }
                                CMSProperty prop = new CMSProperty(name, line.substring(i + 1), type, true);
                                i = line.length();
                                currentCat.set(name, prop);
                                continue block33;
                            }
                            case ':': {
                                type = CMSProperty.Type.tryParse(line.substring(nameStart, nameEnd + 1).charAt(0));
                                nameEnd = -1;
                                nameStart = -1;
                                continue block33;
                            }
                            case '<': {
                                if (tmpList != null) {
                                    throw new RuntimeException(String.format("Malformed list CMSProperty \"%s:%d\"", this.fileName, lineNum));
                                }
                                name = line.substring(nameStart, nameEnd + 1);
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("'%s' has no scope in '%s:%d'", name, this.fileName, lineNum));
                                }
                                tmpList = new ArrayList<String>();
                                if (line.length() > i + 1) {
                                    if (line.charAt(i + 1) == '>') {
                                        ++i;
                                    } else {
                                        line = line.substring(i + 1, line.length());
                                        String[] values = line.split(":|\\>");
                                        for (int j = 0; j < values.length; ++j) {
                                            tmpList.add(values[j]);
                                        }
                                        i = line.length() - 1;
                                    }
                                } else {
                                    skip = true;
                                    continue block33;
                                }
                            }
                            case '>': {
                                if (tmpList == null) {
                                    throw new RuntimeException(String.format("Malformed list CMSProperty \"%s:%d\"", this.fileName, lineNum));
                                }
                                currentCat.set(name, new CMSProperty(name, (List<String>)tmpList, type));
                                name = null;
                                tmpList = null;
                                type = null;
                                continue block33;
                            }
                            default: {
                                throw new RuntimeException(String.format("Unknown character '%s' in '%s:%d'", Character.valueOf(line.charAt(i)), this.fileName, lineNum));
                            }
                        }
                    }
                    if (quoted) {
                        throw new RuntimeException(String.format("Unmatched quote in '%s:%d'", this.fileName, lineNum));
                    }
                    if (tmpList == null || skip) continue;
                    tmpList.add(line.trim());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.resetChangedState();
    }

    public void save() {
        if (PARENT != null && PARENT != this) {
            PARENT.save();
            return;
        }
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(this.file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.defaultEncoding));
                buffer.write("# Configuration file" + NEW_LINE + NEW_LINE);
                if (this.children.isEmpty()) {
                    this.save(buffer);
                } else {
                    for (Map.Entry<String, CMSConfiguration> entry : this.children.entrySet()) {
                        buffer.write("START: \"" + entry.getKey() + "\"" + NEW_LINE);
                        entry.getValue().save(buffer);
                        buffer.write("END: \"" + entry.getKey() + "\"" + NEW_LINE + NEW_LINE);
                    }
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void save(BufferedWriter out) throws IOException {
        for (CMSConfigCategory cat : this.categories.values()) {
            if (cat.isChild()) continue;
            cat.write(out, 0);
            out.newLine();
        }
    }

    public CMSConfigCategory getCategory(String category) {
        CMSConfigCategory ret = this.categories.get(category.toLowerCase());
        if (ret == null) {
            if (category.contains(CATEGORY_SPLITTER)) {
                String[] hierarchy = category.split("\\.");
                CMSConfigCategory parent = this.categories.get(hierarchy[0]);
                if (parent == null) {
                    parent = new CMSConfigCategory(hierarchy[0]);
                    this.categories.put(parent.getQualifiedName(), parent);
                    this.changed = true;
                }
                for (int i = 1; i < hierarchy.length; ++i) {
                    String name = CMSConfigCategory.getQualifiedName(hierarchy[i], parent);
                    CMSConfigCategory child = this.categories.get(name);
                    if (child == null) {
                        child = new CMSConfigCategory(hierarchy[i], parent);
                        this.categories.put(name, child);
                        this.changed = true;
                    }
                    ret = child;
                    parent = child;
                }
            } else {
                ret = new CMSConfigCategory(category);
                this.categories.put(category, ret);
                this.changed = true;
            }
        }
        return ret;
    }

    public void removeCategory(CMSConfigCategory category) {
        for (CMSConfigCategory child : category.getChildren()) {
            this.removeCategory(child);
        }
        if (this.categories.containsKey(category.getQualifiedName())) {
            this.categories.remove(category.getQualifiedName());
            if (category.parent != null) {
                category.parent.removeChild(category);
            }
            this.changed = true;
        }
    }

    public void addCustomCategoryComment(String category, String comment) {
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        this.getCategory(category).setComment(comment);
    }

    private void setChild(String name, CMSConfiguration child) {
        if (!this.children.containsKey(name)) {
            this.children.put(name, child);
            this.changed = true;
        } else {
            CMSConfiguration old = this.children.get(name);
            child.categories = old.categories;
            child.fileName = old.fileName;
            old.changed = true;
        }
    }

    public static void enableGlobalConfig() {
        PARENT = new CMSConfiguration(new File(Loader.instance().getConfigDir(), "global.cfg"));
        PARENT.load();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (CMSConfigCategory cat : this.categories.values()) {
            if (!cat.hasChanged()) continue;
            return true;
        }
        for (CMSConfiguration child : this.children.values()) {
            if (!child.hasChanged()) continue;
            return true;
        }
        return false;
    }

    private void resetChangedState() {
        this.changed = false;
        for (CMSConfigCategory cat : this.categories.values()) {
            cat.resetChangedState();
        }
        for (CMSConfiguration child : this.children.values()) {
            child.resetChangedState();
        }
    }

    public Set<String> getCategoryNames() {
        return ImmutableSet.copyOf(this.categories.keySet());
    }

    public String getFileName() {
        if (this.file != null) {
            String fullName = this.file.getName();
            return fullName.substring(0, fullName.indexOf(46));
        }
        return "undefined";
    }

    public File getFile() {
        return this.file;
    }

    static {
        CONFIG_START = Pattern.compile("START: \"([^\\\"]+)\"");
        CONFIG_END = Pattern.compile("END: \"([^\\\"]+)\"");
        allowedProperties = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)ALLOWED_CHARS));
        PARENT = null;
        NEW_LINE = System.getProperty("line.separator");
    }

    public static class UnicodeInputStreamReader
    extends Reader {
        private final InputStreamReader input;

        public UnicodeInputStreamReader(InputStream source, String encoding) throws IOException {
            String enc = encoding;
            byte[] data = new byte[4];
            PushbackInputStream pbStream = new PushbackInputStream(source, data.length);
            int read = pbStream.read(data, 0, data.length);
            int size = 0;
            int bom16 = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            int bom24 = bom16 << 8 | data[2] & 0xFF;
            int bom32 = bom24 << 8 | data[3] & 0xFF;
            if (bom24 == 0xEFBBBF) {
                enc = CMSConfiguration.DEFAULT_ENCODING;
                size = 3;
            } else if (bom16 == 65279) {
                enc = "UTF-16BE";
                size = 2;
            } else if (bom16 == 65534) {
                enc = "UTF-16LE";
                size = 2;
            } else if (bom32 == 65279) {
                enc = "UTF-32BE";
                size = 4;
            } else if (bom32 == -131072) {
                enc = "UTF-32LE";
                size = 4;
            }
            if (size < read) {
                pbStream.unread(data, size, read - size);
            }
            this.input = new InputStreamReader((InputStream)pbStream, enc);
        }

        public String getEncoding() {
            return this.input.getEncoding();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.input.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

