/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.render.model.CrownModel;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class CrownItem
extends Item {
    private static final ResourceLocation CROWN_TEXTURE = new ResourceLocation("curios", "textures/entity/crown.png");

    public CrownItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1).func_200915_b(2000));
        this.setRegistryName("curios", "crown");
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT unused) {
        return CurioItemCapability.createProvider(new ICurio(){
            private Object model;

            @Override
            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (!livingEntity.func_130014_f_().field_72995_K && livingEntity.field_70173_aa % 20 == 0) {
                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76439_r, 300, -1, true, true));
                    stack.func_222118_a(1, livingEntity, damager -> CuriosApi.getCuriosHelper().onBrokenCurio(identifier, index, (LivingEntity)damager));
                }
            }

            @Override
            public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            @Override
            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (!(this.model instanceof CrownModel)) {
                    this.model = new CrownModel();
                }
                CrownModel crown = (CrownModel)((Object)this.model);
                ICurio.RenderHelper.followHeadRotations(livingEntity, crown.crown);
                IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)crown.func_228282_a_(CROWN_TEXTURE), (boolean)false, (boolean)stack.func_77962_s());
                crown.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return true;
    }
}

