/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.simibubi.create.foundation.gui.IClearableContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class GhostItemContainer<T>
extends Container
implements IClearableContainer {
    public PlayerEntity player;
    public PlayerInventory playerInventory;
    public ItemStackHandler ghostInventory;
    public T contentHolder;

    protected GhostItemContainer(ContainerType<?> type, int id, PlayerInventory inv, PacketBuffer extraData) {
        super(type, id);
        this.init(inv, this.createOnClient(extraData));
    }

    protected GhostItemContainer(ContainerType<?> type, int id, PlayerInventory inv, T contentHolder) {
        super(type, id);
        this.init(inv, contentHolder);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract T createOnClient(PacketBuffer var1);

    protected abstract void addSlots();

    protected abstract ItemStackHandler createGhostInventory();

    protected abstract void readData(T var1);

    protected abstract void saveData(T var1);

    protected abstract boolean allowRepeats();

    protected void init(PlayerInventory inv, T contentHolder) {
        this.player = inv.field_70458_d;
        this.playerInventory = inv;
        this.contentHolder = contentHolder;
        this.ghostInventory = this.createGhostInventory();
        this.readData(contentHolder);
        this.addSlots();
        this.func_75142_b();
    }

    @Override
    public void clearContents() {
        for (int i = 0; i < this.ghostInventory.getSlots(); ++i) {
            this.ghostInventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    protected void addPlayerSlots(int x, int y) {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c == this.playerInventory;
    }

    public boolean func_94531_b(Slot slotIn) {
        if (this.allowRepeats()) {
            return true;
        }
        return slotIn.field_75224_c == this.playerInventory;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack held = this.playerInventory.func_70445_o();
        if (slotId < 36) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (clickTypeIn == ClickType.THROW) {
            return ItemStack.field_190927_a;
        }
        int slot = slotId - 36;
        if (clickTypeIn == ClickType.CLONE) {
            if (player.func_184812_l_() && held.func_190926_b()) {
                ItemStack stackInSlot = this.ghostInventory.getStackInSlot(slot).func_77946_l();
                stackInSlot.func_190920_e(stackInSlot.func_77976_d());
                this.playerInventory.func_70437_b(stackInSlot);
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        if (held.func_190926_b()) {
            this.ghostInventory.setStackInSlot(slot, ItemStack.field_190927_a);
            this.func_75139_a(slotId).func_75218_e();
            return ItemStack.field_190927_a;
        }
        ItemStack insert = held.func_77946_l();
        insert.func_190920_e(1);
        this.ghostInventory.setStackInSlot(slot, insert);
        this.func_75139_a(slotId).func_75218_e();
        return held;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.func_70301_a(index);
            for (int i = 0; i < this.ghostInventory.getSlots(); ++i) {
                ItemStack stack = this.ghostInventory.getStackInSlot(i);
                if (this.allowRepeats() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackToInsert)) {
                    if (!stack.func_190926_b()) continue;
                    ItemStack copy = stackToInsert.func_77946_l();
                    copy.func_190920_e(1);
                    this.ghostInventory.insertItem(i, copy, false);
                    this.func_75139_a(i + 36).func_75218_e();
                }
                break;
            }
        } else {
            this.ghostInventory.extractItem(index - 36, 1, false);
            this.func_75139_a(index).func_75218_e();
        }
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.saveData(this.contentHolder);
    }
}

