/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.palettes;

import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.PaletteBlockPartial;
import com.simibubi.create.content.palettes.PaletteStoneVariants;
import com.simibubi.create.content.palettes.PavedBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PaletteBlockPattern {
    public static final PaletteBlockPattern COBBLESTONE = PaletteBlockPattern.create("cobblestone", PatternNameType.SUFFIX, PaletteBlockPartial.ALL_PARTIALS).addRecipes(v -> (c, p) -> {
        DataIngredient ingredient = DataIngredient.items((IItemProvider)((IItemProvider)c.get()), (IItemProvider[])new Block[0]);
        Block result = v.getBaseBlock().get();
        CookingRecipeBuilder.func_218629_c((Ingredient)ingredient, (IItemProvider)result, (float)0.1f, (int)200).func_218628_a("has_" + p.safeName(ingredient), (ICriterionInstance)ingredient.getCritereon((RegistrateRecipeProvider)p)).func_218635_a((Consumer)p, p.safeId((IForgeRegistryEntry<?>)result));
    });
    public static final PaletteBlockPattern POLISHED = PaletteBlockPattern.create("polished", PatternNameType.PREFIX, PaletteBlockPartial.FOR_POLISHED).addRecipes(v -> (c, p) -> {
        DataIngredient ingredient = DataIngredient.items((IItemProvider)((IItemProvider)v.getBaseBlock().get()), (IItemProvider[])new Block[0]);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)c.get()), (int)4).func_200471_a(Character.valueOf('#'), (Ingredient)ingredient).func_200472_a("##").func_200472_a("##").func_200465_a("has_" + p.safeName(ingredient), (ICriterionInstance)ingredient.getCritereon((RegistrateRecipeProvider)p)).func_200467_a((Consumer)p, p.safeId((IForgeRegistryEntry<?>)c.get()));
    });
    public static final PaletteBlockPattern BRICKS = PaletteBlockPattern.create("bricks", PatternNameType.SUFFIX, PaletteBlockPartial.ALL_PARTIALS);
    public static final PaletteBlockPattern FANCY_BRICKS = PaletteBlockPattern.create("fancy_bricks", PatternNameType.WRAP, PaletteBlockPartial.ALL_PARTIALS);
    public static final PaletteBlockPattern PAVED = PaletteBlockPattern.create("paved", PatternNameType.PREFIX, PaletteBlockPartial.ALL_PARTIALS).blockStateFactory(p -> p::paved).block(PavedBlock::new).textures("paved", "paved_borderless", "paved_top");
    public static final PaletteBlockPattern LAYERED = PaletteBlockPattern.create("layered", PatternNameType.PREFIX, new PaletteBlockPartial[0]).blockStateFactory(p -> p::cubeColumn).textures("layered", "polished").connectedTextures(v -> new HorizontalCTBehaviour(PaletteBlockPattern.ct(v, CTs.LAYERED), PaletteBlockPattern.ct(v, CTs.POLISHED)));
    public static final PaletteBlockPattern CHISELED = PaletteBlockPattern.create("chiseled", PatternNameType.PREFIX, new PaletteBlockPartial[0]).blockStateFactory(p -> p::cubeColumn).textures("chiseled", "chiseled_top");
    public static final PaletteBlockPattern PILLAR = PaletteBlockPattern.create("pillar", PatternNameType.SUFFIX, new PaletteBlockPartial[0]).blockStateFactory(p -> p::pillar).block(RotatedPillarBlock::new).textures("pillar", "pillar_end").addRecipes(v -> (c, p) -> {
        DataIngredient ingredient = DataIngredient.items((IItemProvider)((IItemProvider)v.getBaseBlock().get()), (IItemProvider[])new Block[0]);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)c.get()), (int)2).func_200471_a(Character.valueOf('#'), (Ingredient)ingredient).func_200472_a("#").func_200472_a("#").func_200465_a("has_" + p.safeName(ingredient), (ICriterionInstance)ingredient.getCritereon((RegistrateRecipeProvider)p)).func_200467_a((Consumer)p, p.safeId((IForgeRegistryEntry<?>)c.get()));
    });
    public static final PaletteBlockPattern MOSSY = PaletteBlockPattern.create("mossy", PatternNameType.PREFIX, new PaletteBlockPartial[0]).blockStateFactory(p -> p::cubeAllButMossy).textures("bricks", "mossy").useTranslucentLayer().withFoliage();
    public static final PaletteBlockPattern OVERGROWN = PaletteBlockPattern.create("overgrown", PatternNameType.PREFIX, new PaletteBlockPartial[0]).blockStateFactory(p -> p::cubeAllButMossy).textures("bricks", "overgrown").useTranslucentLayer().withFoliage();
    public static final PaletteBlockPattern[] VANILLA_RANGE = new PaletteBlockPattern[]{COBBLESTONE, BRICKS, FANCY_BRICKS, PILLAR, PAVED, LAYERED, MOSSY, OVERGROWN};
    public static final PaletteBlockPattern[] STANDARD_RANGE = new PaletteBlockPattern[]{COBBLESTONE, POLISHED, BRICKS, FANCY_BRICKS, PILLAR, PAVED, LAYERED, CHISELED, MOSSY, OVERGROWN};
    static final String TEXTURE_LOCATION = "block/palettes/%s/%s";
    static final String OVERLAY_LOCATION = "block/palettes/%s";
    private PatternNameType nameType;
    private String[] textures;
    private String id;
    private boolean isTranslucent;
    private boolean hasFoliage;
    private Optional<Function<PaletteStoneVariants, ConnectedTextureBehaviour>> ctBehaviour;
    private IPatternBlockStateGenerator blockStateGenerator;
    private NonNullFunction<AbstractBlock.Properties, ? extends Block> blockFactory;
    private NonNullFunction<PaletteStoneVariants, NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateRecipeProvider>> additionalRecipes;
    private PaletteBlockPartial<? extends Block>[] partials;
    @OnlyIn(value=Dist.CLIENT)
    private RenderType renderType;

    private static PaletteBlockPattern create(String name, PatternNameType nameType, PaletteBlockPartial<?> ... partials) {
        PaletteBlockPattern pattern = new PaletteBlockPattern();
        pattern.id = name;
        pattern.ctBehaviour = Optional.empty();
        pattern.nameType = nameType;
        pattern.partials = partials;
        pattern.additionalRecipes = $ -> NonNullBiConsumer.noop();
        pattern.isTranslucent = false;
        pattern.hasFoliage = false;
        pattern.blockFactory = Block::new;
        pattern.textures = new String[]{name};
        pattern.blockStateGenerator = p -> p::cubeAll;
        return pattern;
    }

    public IPatternBlockStateGenerator getBlockStateGenerator() {
        return this.blockStateGenerator;
    }

    public boolean isTranslucent() {
        return this.isTranslucent;
    }

    public boolean hasFoliage() {
        return this.hasFoliage;
    }

    public NonNullFunction<AbstractBlock.Properties, ? extends Block> getBlockFactory() {
        return this.blockFactory;
    }

    public PaletteBlockPartial<? extends Block>[] getPartials() {
        return this.partials;
    }

    public String getTextureForPartials() {
        return this.textures[0];
    }

    public void addRecipes(PaletteStoneVariants variant, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
        this.additionalRecipes.apply(variant).accept(c, p);
    }

    public Optional<ConnectedTextureBehaviour> createCTBehaviour(PaletteStoneVariants variant) {
        return this.ctBehaviour.map(f -> (ConnectedTextureBehaviour)f.apply(variant));
    }

    private PaletteBlockPattern blockStateFactory(IPatternBlockStateGenerator factory) {
        this.blockStateGenerator = factory;
        return this;
    }

    private PaletteBlockPattern textures(String ... textures) {
        this.textures = textures;
        return this;
    }

    private PaletteBlockPattern block(NonNullFunction<AbstractBlock.Properties, ? extends Block> blockFactory) {
        this.blockFactory = blockFactory;
        return this;
    }

    private PaletteBlockPattern useTranslucentLayer() {
        this.isTranslucent = true;
        return this;
    }

    private PaletteBlockPattern withFoliage() {
        this.hasFoliage = true;
        return this;
    }

    private PaletteBlockPattern connectedTextures(Function<PaletteStoneVariants, ConnectedTextureBehaviour> factory) {
        this.ctBehaviour = Optional.of(factory);
        return this;
    }

    private PaletteBlockPattern addRecipes(NonNullFunction<PaletteStoneVariants, NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateRecipeProvider>> func) {
        this.additionalRecipes = func;
        return this;
    }

    public IBlockStateProvider cubeAll(String variant) {
        ResourceLocation all = this.toLocation(variant, this.textures[0]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(this.createName(variant), all));
    }

    public IBlockStateProvider cubeAllButMossy(String variant) {
        ResourceLocation all = this.toLocation(variant, this.textures[0]);
        ResourceLocation overlay = this.toOverlayLocation(this.textures[1]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), ModelGen.createOvergrown(ctx, prov, all, overlay));
    }

    public IBlockStateProvider cubeBottomTop(String variant) {
        ResourceLocation side = this.toLocation(variant, this.textures[0]);
        ResourceLocation bottom = this.toLocation(variant, this.textures[1]);
        ResourceLocation top = this.toLocation(variant, this.textures[2]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(this.createName(variant), side, bottom, top));
    }

    public IBlockStateProvider pillar(String variant) {
        ResourceLocation side = this.toLocation(variant, this.textures[0]);
        ResourceLocation end = this.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> BlockStateGen.axisBlock(ctx, prov, $ -> (BlockModelBuilder)prov.models().cubeColumn(this.createName(variant), side, end));
    }

    public IBlockStateProvider cubeColumn(String variant) {
        ResourceLocation side = this.toLocation(variant, this.textures[0]);
        ResourceLocation end = this.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeColumn(this.createName(variant), side, end));
    }

    public IBlockStateProvider paved(String variant) {
        ResourceLocation side = this.toLocation(variant, this.textures[0]);
        ResourceLocation bottom = this.toLocation(variant, this.textures[1]);
        ResourceLocation top = this.toLocation(variant, this.textures[2]);
        return (ctx, prov) -> {
            ModelBuilder cubeBottomTop = prov.models().cubeBottomTop(this.createName(variant), side, bottom, top);
            ModelBuilder cubeAll = prov.models().cubeAll(this.createName(variant) + "_covered", bottom);
            BlockStateGen.pavedBlock(ctx, prov, (ModelFile)cubeBottomTop, (ModelFile)cubeAll);
        };
    }

    protected String createName(String variant) {
        String[] split;
        if (this.nameType == PatternNameType.WRAP && (split = this.id.split("_")).length == 2) {
            String formatString = "%s_%s_%s";
            return String.format(formatString, split[0], variant, split[1]);
        }
        String formatString = "%s_%s";
        return this.nameType == PatternNameType.SUFFIX ? String.format(formatString, variant, this.id) : String.format(formatString, this.id, variant);
    }

    protected ResourceLocation toLocation(String variant, String texture) {
        return Create.asResource(String.format(TEXTURE_LOCATION, variant, texture));
    }

    protected ResourceLocation toOverlayLocation(String texture) {
        return Create.asResource(String.format(OVERLAY_LOCATION, texture));
    }

    protected static CTSpriteShiftEntry ct(PaletteStoneVariants variant, CTs texture) {
        return AllSpriteShifts.getVariantPattern(variant, texture);
    }

    public static enum CTs {
        POLISHED(CTSpriteShifter.CTType.OMNIDIRECTIONAL),
        LAYERED(CTSpriteShifter.CTType.HORIZONTAL);

        public CTSpriteShifter.CTType type;

        private CTs(CTSpriteShifter.CTType type) {
            this.type = type;
        }
    }

    static enum PatternNameType {
        PREFIX,
        SUFFIX,
        WRAP;

    }

    @FunctionalInterface
    static interface IBlockStateProvider
    extends NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateBlockstateProvider> {
    }

    @FunctionalInterface
    static interface IPatternBlockStateGenerator
    extends Function<PaletteBlockPattern, Function<String, IBlockStateProvider>> {
    }
}

