/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.inventories;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateContainer;
import com.simibubi.create.content.logistics.block.inventories.CrateTileEntity;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AdjustableCrateTileEntity
extends CrateTileEntity
implements INamedContainerProvider {
    public Inv inventory = new Inv();
    public int allowedAmount = 512;
    public int itemCount = 10;
    protected LazyOptional<IItemHandler> invHandler = LazyOptional.of(() -> this.inventory);

    public AdjustableCrateTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return AdjustableCrateContainer.create(id, inventory, this);
    }

    public AdjustableCrateTileEntity getOtherCrate() {
        if (!AllBlocks.ADJUSTABLE_CRATE.has(this.func_195044_w())) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tileEntity instanceof AdjustableCrateTileEntity) {
            return (AdjustableCrateTileEntity)tileEntity;
        }
        return null;
    }

    public AdjustableCrateTileEntity getMainCrate() {
        if (this.isSecondaryCrate()) {
            return this.getOtherCrate();
        }
        return this;
    }

    public void onSplit() {
        int slot;
        AdjustableCrateTileEntity other = this.getOtherCrate();
        if (other == null) {
            return;
        }
        if (other == this.getMainCrate()) {
            other.onSplit();
            return;
        }
        other.allowedAmount = Math.max(1, this.allowedAmount - 1024);
        for (slot = 0; slot < other.inventory.getSlots(); ++slot) {
            other.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        for (slot = 16; slot < this.inventory.getSlots(); ++slot) {
            other.inventory.setStackInSlot(slot - 16, this.inventory.getStackInSlot(slot));
            this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        this.allowedAmount = Math.min(1024, this.allowedAmount);
        this.invHandler.invalidate();
        this.invHandler = LazyOptional.of(() -> this.inventory);
        other.invHandler.invalidate();
        other.invHandler = LazyOptional.of(() -> other.inventory);
    }

    public void onDestroyed() {
        int slot;
        AdjustableCrateTileEntity other = this.getOtherCrate();
        if (other == null) {
            for (int slot2 = 0; slot2 < this.inventory.getSlots(); ++slot2) {
                this.drop(slot2);
            }
            return;
        }
        AdjustableCrateTileEntity main = this.getMainCrate();
        if (this == main) {
            for (slot = 0; slot < this.inventory.getSlots(); ++slot) {
                other.inventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            other.allowedAmount = Math.min(1024, this.allowedAmount);
        }
        for (slot = 16; slot < other.inventory.getSlots(); ++slot) {
            other.drop(slot);
        }
        other.invHandler.invalidate();
        other.invHandler = LazyOptional.of(() -> other.inventory);
    }

    private void drop(int slot) {
        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(slot));
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Main", true);
        compound.func_74768_a("AllowedAmount", this.allowedAmount);
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.allowedAmount = compound.func_74762_e("AllowedAmount");
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        super.fromTag(state, compound, clientPacket);
    }

    public ITextComponent func_145748_c_() {
        return Lang.translate("gui.adjustable_crate.title", new Object[0]);
    }

    public void sendToContainer(PacketBuffer buffer) {
        buffer.func_179255_a(this.func_174877_v());
        buffer.func_150786_a(this.func_189517_E_());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.invHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        AdjustableCrateTileEntity mainCrate;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (mainCrate = this.getMainCrate()) != null && mainCrate.invHandler != null && mainCrate.invHandler.isPresent()) {
            return mainCrate.invHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public class Inv
    extends ItemStackHandler {
        public Inv() {
            super(32);
        }

        public int getSlotLimit(int slot) {
            if (slot < AdjustableCrateTileEntity.this.allowedAmount / 64) {
                return super.getSlotLimit(slot);
            }
            if (slot == AdjustableCrateTileEntity.this.allowedAmount / 64) {
                return AdjustableCrateTileEntity.this.allowedAmount % 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot > AdjustableCrateTileEntity.this.allowedAmount / 64) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AdjustableCrateTileEntity.this.func_70296_d();
            AdjustableCrateTileEntity.this.itemCount = 0;
            for (int i = 0; i < this.getSlots(); ++i) {
                AdjustableCrateTileEntity.this.itemCount += this.getStackInSlot(i).func_190916_E();
            }
        }
    }
}

