/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.curiosities.zapper.ZapperScreen;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainBrushes;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class WorldshaperScreen
extends ZapperScreen {
    protected final ITextComponent placementSection = Lang.translate("gui.terrainzapper.placement", new Object[0]);
    protected final ITextComponent toolSection = Lang.translate("gui.terrainzapper.tool", new Object[0]);
    protected final List<ITextComponent> brushOptions = Lang.translatedOptions("gui.terrainzapper.brush", "cuboid", "sphere", "cylinder", "surface", "cluster");
    protected Vector<IconButton> toolButtons;
    protected Vector<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected Vector<ScrollInput> brushParams;
    protected Vector<Label> brushParamLabels;
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    private CompoundNBT nbt;

    public WorldshaperScreen(ItemStack zapper, boolean offhand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, offhand);
        this.fontColor = 0x767676;
        this.field_230704_d_ = zapper.func_200301_q();
        this.nbt = zapper.func_196082_o();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brushLabel = new Label(x + 61, y + 25, StringTextComponent.field_240750_d_).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled((IFormattableTextComponent)Lang.translate("gui.terrainzapper.brush", new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> this.initBrushParams(x, y));
        if (this.nbt.func_74764_b("Brush")) {
            this.brushInput.setState(NBTHelper.readEnum(this.nbt, "Brush", TerrainBrushes.class).ordinal());
        }
        this.widgets.add(this.brushLabel);
        this.widgets.add(this.brushInput);
        this.initBrushParams(x, y);
    }

    public void initBrushParams(int x, int y) {
        int optionIndex;
        if (this.brushParams != null) {
            this.nbt.func_218657_a("BrushParams", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos(this.brushParams.get(0).getState(), this.brushParams.get(1).getState(), this.brushParams.get(2).getState())));
            this.widgets.removeAll(this.brushParamLabels);
            this.widgets.removeAll(this.brushParams);
        }
        this.brushParamLabels = new Vector(3);
        this.brushParams = new Vector(3);
        BlockPos data = NBTUtil.func_186861_c((CompoundNBT)this.nbt.func_74775_l("BrushParams"));
        int[] params = new int[]{data.func_177958_n(), data.func_177956_o(), data.func_177952_p()};
        Brush currentBrush = TerrainBrushes.values()[this.brushInput.getState()].get();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, StringTextComponent.field_240750_d_).withShadow();
            this.brushParamLabels.add(label);
            int indexFinal = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(currentBrush.getParamLabel(index).func_230531_f_()).calling(state -> {
                label.field_230690_l_ = x + 65 + 20 * indexFinal - this.field_230712_o_.func_238414_a_((ITextProperties)label.text) / 2;
            });
            input.setState(params[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.field_230694_p_ = false;
                label.field_230694_p_ = false;
                input.field_230693_o_ = false;
            }
            this.brushParams.add(input);
        }
        this.widgets.addAll(this.brushParamLabels);
        this.widgets.addAll(this.brushParams);
        if (this.followDiagonals != null) {
            this.widgets.remove((Object)this.followDiagonals);
            this.widgets.remove((Object)this.followDiagonalsIndicator);
            this.widgets.remove((Object)this.acrossMaterials);
            this.widgets.remove((Object)this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 7 + 72;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, StringTextComponent.field_240750_d_);
            this.followDiagonals = new IconButton(x1, y1, AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, StringTextComponent.field_240750_d_);
            this.acrossMaterials = new IconButton(x1, y1, AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.searchDiagonal", new Object[0]));
            this.acrossMaterials.setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.searchFuzzy", new Object[0]));
            this.widgets.add(this.followDiagonals);
            this.widgets.add(this.followDiagonalsIndicator);
            this.widgets.add(this.acrossMaterials);
            this.widgets.add(this.acrossMaterialsIndicator);
            if (params[1] == 0) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (params[2] == 0) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.widgets.removeAll(this.toolButtons);
        }
        TerrainTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new Vector(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            this.toolButtons.add(new IconButton(x + 7 + id * 18, y + 79, tool.icon));
            this.toolButtons.get(id).setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.tool." + tool.translationKey, new Object[0]));
        }
        if (!this.nbt.func_74764_b("Tool")) {
            NBTHelper.writeEnum(this.nbt, "Tool", toolValues[0]);
        }
        int index = -1;
        TerrainTools tool = NBTHelper.readEnum(this.nbt, "Tool", TerrainTools.class);
        for (int i = 0; i < toolValues.length; ++i) {
            if (tool != toolValues[i]) continue;
            index = i;
        }
        if (index == -1) {
            NBTHelper.writeEnum(this.nbt, "Tool", toolValues[0]);
            index = 0;
        }
        this.toolButtons.get((int)index).field_230693_o_ = false;
        this.widgets.addAll(this.toolButtons);
        if (this.placementButtons != null) {
            this.widgets.removeAll(this.placementButtons);
        }
        if (!currentBrush.hasPlacementOptions()) {
            return;
        }
        PlacementOptions[] placementValues = PlacementOptions.values();
        this.placementButtons = new Vector(placementValues.length);
        for (int id = 0; id < placementValues.length; ++id) {
            PlacementOptions option = placementValues[id];
            this.placementButtons.add(new IconButton(x + 136 + id * 18, y + 79, option.icon));
            this.placementButtons.get(id).setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.placement." + option.translationKey, new Object[0]));
        }
        if (!this.nbt.func_74764_b("Placement")) {
            NBTHelper.writeEnum(this.nbt, "Placement", placementValues[0]);
        }
        if ((optionIndex = NBTHelper.readEnum(this.nbt, "Placement", PlacementOptions.class).ordinal()) >= placementValues.length) {
            NBTHelper.writeEnum(this.nbt, "Placement", placementValues[0]);
            optionIndex = 0;
        }
        this.placementButtons.get((int)optionIndex).field_230693_o_ = false;
        this.widgets.addAll(this.placementButtons);
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        CompoundNBT nbt = this.zapper.func_77978_p();
        TerrainBrushes brush = TerrainBrushes.values()[this.brushInput.getState()];
        TerrainTools[] supportedTools = brush.get().getSupportedTools();
        if (this.placementButtons != null) {
            for (IconButton placementButton : this.placementButtons) {
                if (!placementButton.func_230449_g_()) continue;
                this.placementButtons.forEach(b -> {
                    b.field_230693_o_ = true;
                });
                placementButton.field_230693_o_ = false;
                placementButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                nbt.func_74778_a("Placement", PlacementOptions.values()[this.placementButtons.indexOf((Object)placementButton)].name());
            }
        }
        for (IconButton toolButton : this.toolButtons) {
            if (!toolButton.func_230449_g_()) continue;
            this.toolButtons.forEach(b -> {
                b.field_230693_o_ = true;
            });
            toolButton.field_230693_o_ = false;
            toolButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            nbt.func_74778_a("Tool", supportedTools[this.toolButtons.indexOf((Object)toolButton)].name());
        }
        if (this.followDiagonals != null && this.followDiagonals.func_230449_g_()) {
            Indicator.State state = this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
        }
        if (this.acrossMaterials != null && this.acrossMaterials.func_230449_g_()) {
            this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    protected void drawOnBackground(MatrixStack matrixStack, int x, int y) {
        super.drawOnBackground(matrixStack, x, y);
        Brush currentBrush = TerrainBrushes.values()[this.brushInput.getState()].get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.draw(matrixStack, x + 56 + 20 * index, y + 40);
        }
        this.field_230712_o_.func_243248_b(matrixStack, this.toolSection, (float)(x + 7), (float)(y + 69), this.fontColor);
        if (currentBrush.hasPlacementOptions()) {
            this.field_230712_o_.func_243248_b(matrixStack, this.placementSection, (float)(x + 136), (float)(y + 69), this.fontColor);
        }
    }

    @Override
    protected void writeAdditionalOptions(CompoundNBT nbt) {
        int param2;
        super.writeAdditionalOptions(nbt);
        TerrainBrushes brush = TerrainBrushes.values()[this.brushInput.getState()];
        int param1 = this.brushParams.get(0).getState();
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (param2 = this.brushParams.get(1).getState());
        int param3 = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.brushParams.get(2).getState();
        NBTHelper.writeEnum(nbt, "Brush", brush);
        nbt.func_218657_a("BrushParams", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos(param1, param2, param3)));
    }
}

