/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class FlattenTool {
    static float[][] kernel = new float[][]{{0.003765f, 0.015019f, 0.023792f, 0.015019f, 0.003765f}, {0.015019f, 0.059912f, 0.094907f, 0.059912f, 0.015019f}, {0.023792f, 0.094907f, 0.150342f, 0.094907f, 0.023792f}, {0.015019f, 0.059912f, 0.094907f, 0.059912f, 0.015019f}, {0.003765f, 0.015019f, 0.023792f, 0.015019f, 0.003765f}};

    private static int[][] applyKernel(int[][] values) {
        int[][] result = new int[values.length][values[0].length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                int value = values[i][j];
                float newValue = 0.0f;
                for (int iOffset = -2; iOffset <= 2; ++iOffset) {
                    for (int jOffset = -2; jOffset <= 2; ++jOffset) {
                        int iTarget = i + iOffset;
                        int jTarget = j + jOffset;
                        int ref = 0;
                        ref = iTarget < 0 || iTarget >= values.length || jTarget < 0 || jTarget >= values[0].length ? value : values[iTarget][jTarget];
                        if (ref == Integer.MIN_VALUE) {
                            ref = value;
                        }
                        newValue += kernel[iOffset + 2][jOffset + 2] * (float)ref;
                    }
                }
                result[i][j] = MathHelper.func_76141_d((float)(newValue + 0.5f));
            }
        }
        return result;
    }

    public static void apply(World world, List<BlockPos> targetPositions, Direction facing) {
        ArrayList<BlockPos> surfaces = new ArrayList<BlockPos>();
        HashMap<Pair<Integer, Integer>, Integer> heightMap = new HashMap<Pair<Integer, Integer>, Integer>();
        int offset = facing.func_176743_c().func_179524_a();
        int minEntry = Integer.MAX_VALUE;
        int minCoord1 = Integer.MAX_VALUE;
        int minCoord2 = Integer.MAX_VALUE;
        int maxEntry = Integer.MIN_VALUE;
        int maxCoord1 = Integer.MIN_VALUE;
        int maxCoord2 = Integer.MIN_VALUE;
        for (BlockPos p : targetPositions) {
            Pair<Integer, Integer> coords = FlattenTool.getCoords(p, facing);
            BlockState belowSurface = world.func_180495_p(p);
            minCoord1 = Math.min(minCoord1, (Integer)coords.getKey());
            minCoord2 = Math.min(minCoord2, (Integer)coords.getValue());
            maxCoord1 = Math.max(maxCoord1, (Integer)coords.getKey());
            maxCoord2 = Math.max(maxCoord2, (Integer)coords.getValue());
            if (TerrainTools.isReplaceable(belowSurface)) {
                if (heightMap.containsKey(coords)) continue;
                heightMap.put(coords, Integer.MIN_VALUE);
                continue;
            }
            BlockState surface = world.func_180495_p(p = p.func_177972_a(facing));
            if (!TerrainTools.isReplaceable(surface)) {
                if (heightMap.containsKey(coords) && !((Integer)heightMap.get(coords)).equals(Integer.MIN_VALUE)) continue;
                heightMap.put(coords, Integer.MAX_VALUE);
                continue;
            }
            surfaces.add(p);
            int coordinate = facing.func_176740_k().func_196052_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            if (heightMap.containsKey(coords) && !((Integer)heightMap.get(coords)).equals(Integer.MAX_VALUE) && !((Integer)heightMap.get(coords)).equals(Integer.MIN_VALUE) && (Integer)heightMap.get(coords) * offset >= coordinate * offset) continue;
            heightMap.put(coords, coordinate);
            maxEntry = Math.max(maxEntry, coordinate);
            minEntry = Math.min(minEntry, coordinate);
        }
        if (surfaces.isEmpty()) {
            return;
        }
        int[][] heightMapArray = new int[maxCoord1 - minCoord1 + 1][maxCoord2 - minCoord2 + 1];
        for (int i = 0; i < heightMapArray.length; ++i) {
            for (int j = 0; j < heightMapArray[i].length; ++j) {
                Integer height;
                Pair pair = Pair.of((Object)(minCoord1 + i), (Object)(minCoord2 + j));
                heightMapArray[i][j] = !heightMap.containsKey(pair) ? Integer.MIN_VALUE : ((height = (Integer)heightMap.get(pair)).equals(Integer.MAX_VALUE) ? (offset == 1 ? maxEntry + 2 : minEntry - 2) : (height.equals(Integer.MIN_VALUE) ? (offset == 1 ? minEntry - 2 : maxEntry + 2) : height));
            }
        }
        heightMapArray = FlattenTool.applyKernel(heightMapArray);
        block3: for (BlockPos p : surfaces) {
            int targetCoord;
            Pair<Integer, Integer> coords = FlattenTool.getCoords(p, facing);
            int surfaceCoord = facing.func_176740_k().func_196052_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()) * offset;
            if (surfaceCoord == (targetCoord = heightMapArray[(Integer)coords.getKey() - minCoord1][(Integer)coords.getValue() - minCoord2] * offset)) continue;
            BlockState blockState = world.func_180495_p(p);
            int timeOut = 1000;
            while (surfaceCoord > targetCoord) {
                BlockPos below = p.func_177972_a(facing.func_176734_d());
                world.func_175656_a(below, blockState);
                world.func_175656_a(p, blockState.func_204520_s().func_206883_i());
                p = p.func_177972_a(facing.func_176734_d());
                --surfaceCoord;
                if (timeOut-- > 0) continue;
                break;
            }
            while (surfaceCoord < targetCoord) {
                BlockPos above = p.func_177972_a(facing);
                if (!(blockState.func_177230_c() instanceof FlowingFluidBlock)) {
                    world.func_175656_a(above, blockState);
                }
                world.func_175656_a(p, world.func_180495_p(p.func_177972_a(facing.func_176734_d())));
                p = p.func_177972_a(facing);
                ++surfaceCoord;
                if (timeOut-- > 0) continue;
                continue block3;
            }
        }
    }

    private static Pair<Integer, Integer> getCoords(BlockPos pos, Direction facing) {
        switch (facing.func_176740_k()) {
            case X: {
                return Pair.of((Object)pos.func_177952_p(), (Object)pos.func_177956_o());
            }
            case Y: {
                return Pair.of((Object)pos.func_177958_n(), (Object)pos.func_177952_p());
            }
            case Z: {
                return Pair.of((Object)pos.func_177958_n(), (Object)pos.func_177956_o());
            }
        }
        return null;
    }
}

