/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.item;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class BeltConnectorItem
extends BlockItem {
    public BeltConnectorItem(Item.Properties properties) {
        super((Block)AllBlocks.BELT.get(), properties);
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    public void func_150895_a(ItemGroup p_150895_1_, NonNullList<ItemStack> p_150895_2_) {
        if (p_150895_1_ == Create.BASE_CREATIVE_TAB) {
            return;
        }
        super.func_150895_a(p_150895_1_, p_150895_2_);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity playerEntity = context.func_195999_j();
        if (playerEntity != null && playerEntity.func_225608_bj_()) {
            context.func_195996_i().func_77982_d(null);
            return ActionResultType.SUCCESS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        boolean validAxis = BeltConnectorItem.validateAxis(world, pos);
        if (world.field_72995_K) {
            return validAxis ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        CompoundNBT tag = context.func_195996_i().func_196082_o();
        BlockPos firstPulley = null;
        if (!(!tag.func_74764_b("FirstPulley") || BeltConnectorItem.validateAxis(world, firstPulley = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("FirstPulley"))) && firstPulley.func_218141_a((Vector3i)pos, (double)(BeltConnectorItem.maxLength() * 2)))) {
            tag.func_82580_o("FirstPulley");
            context.func_195996_i().func_77982_d(tag);
        }
        if (!validAxis || playerEntity == null) {
            return ActionResultType.FAIL;
        }
        if (tag.func_74764_b("FirstPulley")) {
            if (!BeltConnectorItem.canConnect(world, firstPulley, pos)) {
                return ActionResultType.FAIL;
            }
            if (firstPulley != null && !firstPulley.equals((Object)pos)) {
                BeltConnectorItem.createBelts(world, firstPulley, pos);
                AllTriggers.triggerFor(AllTriggers.CONNECT_BELT, playerEntity);
                if (!playerEntity.func_184812_l_()) {
                    context.func_195996_i().func_190918_g(1);
                }
            }
            if (!context.func_195996_i().func_190926_b()) {
                context.func_195996_i().func_77982_d(null);
                playerEntity.func_184811_cZ().func_185145_a((Item)this, 5);
            }
            return ActionResultType.SUCCESS;
        }
        tag.func_218657_a("FirstPulley", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        context.func_195996_i().func_77982_d(tag);
        playerEntity.func_184811_cZ().func_185145_a((Item)this, 5);
        return ActionResultType.SUCCESS;
    }

    public static void createBelts(World world, BlockPos start, BlockPos end) {
        BeltSlope slope = BeltConnectorItem.getSlopeBetween(start, end);
        Direction facing = BeltConnectorItem.getFacingFromTo(start, end);
        BlockPos diff = end.func_177973_b((Vector3i)start);
        if (diff.func_177958_n() == diff.func_177952_p()) {
            facing = Direction.func_181076_a((Direction.AxisDirection)facing.func_176743_c(), (Direction.Axis)(world.func_180495_p(start).func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        List<BlockPos> beltsToCreate = BeltConnectorItem.getBeltChainBetween(start, end, slope, facing);
        BlockState beltBlock = AllBlocks.BELT.getDefaultState();
        for (BlockPos pos : beltsToCreate) {
            BeltPart part = pos.equals((Object)start) ? BeltPart.START : (pos.equals((Object)end) ? BeltPart.END : BeltPart.MIDDLE);
            BlockState shaftState = world.func_180495_p(pos);
            boolean pulley = ShaftBlock.isShaft(shaftState);
            if (part == BeltPart.MIDDLE && pulley) {
                part = BeltPart.PULLEY;
            }
            if (pulley && shaftState.func_177229_b((Property)AbstractShaftBlock.AXIS) == Direction.Axis.Y) {
                slope = BeltSlope.SIDEWAYS;
            }
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)((BlockState)((BlockState)beltBlock.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)slope))).func_206870_a(BeltBlock.PART, (Comparable)((Object)part))).func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)facing));
        }
    }

    private static Direction getFacingFromTo(BlockPos start, BlockPos end) {
        Direction.Axis beltAxis = start.func_177958_n() == end.func_177958_n() ? Direction.Axis.Z : Direction.Axis.X;
        BlockPos diff = end.func_177973_b((Vector3i)start);
        Direction.AxisDirection axisDirection = Direction.AxisDirection.POSITIVE;
        axisDirection = diff.func_177958_n() == 0 && diff.func_177952_p() == 0 ? (diff.func_177956_o() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE) : (beltAxis.func_196052_a(diff.func_177958_n(), 0, diff.func_177952_p()) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        return Direction.func_181076_a((Direction.AxisDirection)axisDirection, (Direction.Axis)beltAxis);
    }

    private static BeltSlope getSlopeBetween(BlockPos start, BlockPos end) {
        BlockPos diff = end.func_177973_b((Vector3i)start);
        if (diff.func_177956_o() != 0) {
            if (diff.func_177952_p() != 0 || diff.func_177958_n() != 0) {
                return diff.func_177956_o() > 0 ? BeltSlope.UPWARD : BeltSlope.DOWNWARD;
            }
            return BeltSlope.VERTICAL;
        }
        return BeltSlope.HORIZONTAL;
    }

    private static List<BlockPos> getBeltChainBetween(BlockPos start, BlockPos end, BeltSlope slope, Direction direction) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        int limit = 1000;
        BlockPos current = start;
        do {
            positions.add(current);
            if (slope == BeltSlope.VERTICAL) {
                current = current.func_177981_b(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : -1);
                continue;
            }
            current = current.func_177972_a(direction);
            if (slope == BeltSlope.HORIZONTAL) continue;
            current = current.func_177981_b(slope == BeltSlope.UPWARD ? 1 : -1);
        } while (!current.equals((Object)end) && limit-- > 0);
        positions.add(end);
        return positions;
    }

    public static boolean canConnect(World world, BlockPos first, BlockPos second) {
        if (!world.isAreaLoaded(first, 1)) {
            return false;
        }
        if (!world.isAreaLoaded(second, 1)) {
            return false;
        }
        if (!second.func_218141_a((Vector3i)first, (double)BeltConnectorItem.maxLength().intValue())) {
            return false;
        }
        BlockPos diff = second.func_177973_b((Vector3i)first);
        Direction.Axis shaftAxis = (Direction.Axis)world.func_180495_p(first).func_177229_b((Property)BlockStateProperties.field_208148_A);
        int x = diff.func_177958_n();
        int y = diff.func_177956_o();
        int z = diff.func_177952_p();
        int sames = (Math.abs(x) == Math.abs(y) ? 1 : 0) + (Math.abs(y) == Math.abs(z) ? 1 : 0) + (Math.abs(z) == Math.abs(x) ? 1 : 0);
        if (shaftAxis.func_196052_a(x, y, z) != 0) {
            return false;
        }
        if (sames != 1) {
            return false;
        }
        if (shaftAxis != world.func_180495_p(second).func_177229_b((Property)BlockStateProperties.field_208148_A)) {
            return false;
        }
        if (shaftAxis == Direction.Axis.Y && x != 0 && z != 0) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(first);
        TileEntity tileEntity2 = world.func_175625_s(second);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return false;
        }
        if (!(tileEntity2 instanceof KineticTileEntity)) {
            return false;
        }
        float speed1 = ((KineticTileEntity)tileEntity).getTheoreticalSpeed();
        float speed2 = ((KineticTileEntity)tileEntity2).getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0.0f && speed2 != 0.0f) {
            return false;
        }
        BlockPos step = new BlockPos((double)Math.signum(diff.func_177958_n()), (double)Math.signum(diff.func_177956_o()), (double)Math.signum(diff.func_177952_p()));
        int limit = 1000;
        BlockPos currentPos = first.func_177971_a((Vector3i)step);
        while (!currentPos.equals((Object)second) && limit-- > 0) {
            BlockState blockState = world.func_180495_p(currentPos);
            if (!(ShaftBlock.isShaft(blockState) && blockState.func_177229_b((Property)AbstractShaftBlock.AXIS) == shaftAxis || blockState.func_185904_a().func_76222_j())) {
                return false;
            }
            currentPos = currentPos.func_177971_a((Vector3i)step);
        }
        return true;
    }

    protected static Integer maxLength() {
        return (Integer)AllConfigs.SERVER.kinetics.maxBeltLength.get();
    }

    public static boolean validateAxis(World world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        return ShaftBlock.isShaft(world.func_180495_p(pos));
    }
}

