/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BasinRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(BasinTileEntity basin, IRecipe<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.func_77571_b());
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return BasinRecipe.apply(basin, recipe, true);
    }

    public static boolean apply(BasinTileEntity basin, IRecipe<?> recipe) {
        return BasinRecipe.apply(basin, recipe, false);
    }

    private static boolean apply(BasinTileEntity basin, IRecipe<?> recipe, boolean test) {
        boolean isBasinRecipe = recipe instanceof BasinRecipe;
        IItemHandler availableItems = (IItemHandler)basin.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinTileEntity.getHeatLevelOf(basin.func_145831_w().func_180495_p(basin.func_174877_v().func_177979_c(1)));
        if (isBasinRecipe && !((BasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList<Ingredient> ingredients = new LinkedList<Ingredient>((Collection<Ingredient>)recipe.func_192400_c());
        ingredients.sort(Comparator.comparingInt(i -> i.func_193365_a().length));
        List fluidIngredients = isBasinRecipe ? ((BasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                Ingredient ingredient = (Ingredient)ingredients.get(i2);
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).func_190916_E() <= extractedItemsFromSlot[slot] || !ingredient.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (extracted.hasContainerItem() && extracted.getContainerItem().func_77969_a(extracted)) continue block1;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    } else if (extracted.hasContainerItem()) {
                        recipeOutputItems.add(extracted.getContainerItem().func_77946_l());
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            for (int i3 = 0; i3 < fluidIngredients.size(); ++i3) {
                int drainedAmount;
                int tank;
                block17: {
                    FluidIngredient fluidIngredient = (FluidIngredient)fluidIngredients.get(i3);
                    int amountRequired = fluidIngredient.getRequiredAmount();
                    for (tank = 0; tank < availableFluids.getTanks(); ++tank) {
                        FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                        if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                        drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                        if (!simulate) {
                            fluidStack.shrink(drainedAmount);
                            fluidsAffected = true;
                        }
                        if ((amountRequired -= drainedAmount) != 0) {
                            continue;
                        }
                        break block17;
                    }
                    return false;
                }
                int n = tank;
                extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
            }
            if (fluidsAffected) {
                basin.getBehaviour(SmartFluidTankBehaviour.INPUT).foreach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT).foreach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate) {
                if (recipe instanceof BasinRecipe) {
                    recipeOutputItems.addAll(((BasinRecipe)recipe).rollResults());
                    recipeOutputFluids.addAll((Collection<FluidStack>)((BasinRecipe)recipe).getFluidResults());
                } else {
                    recipeOutputItems.add(recipe.func_77571_b());
                }
            }
            if (basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public static BasinRecipe convertShapeless(IRecipe<?> recipe) {
        BasinRecipe basinRecipe = new ProcessingRecipeBuilder<BasinRecipe>(BasinRecipe::new, recipe.func_199560_c()).withItemIngredients((NonNullList<Ingredient>)recipe.func_192400_c()).withSingleItemOutput(recipe.func_77571_b()).build();
        return basinRecipe;
    }

    protected BasinRecipe(AllRecipeTypes type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public BasinRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(AllRecipeTypes.BASIN, params);
    }

    @Override
    protected int getMaxInputCount() {
        return 9;
    }

    @Override
    protected int getMaxOutputCount() {
        return 4;
    }

    @Override
    protected int getMaxFluidInputCount() {
        return 2;
    }

    @Override
    protected int getMaxFluidOutputCount() {
        return 2;
    }

    @Override
    protected boolean canRequireHeat() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull World worldIn) {
        return false;
    }
}

