/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.backend.model.ArrayModelRenderer;
import com.jozufozu.flywheel.backend.model.ModelRenderer;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.core.model.WorldModel;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.light.GridAlignedBB;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionGroup;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionInstanceManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;

public class RenderedContraption
extends ContraptionRenderInfo {
    private final ContraptionLighter<?> lighter;
    public final MaterialManager<ContraptionProgram> materialManager;
    public final ContraptionInstanceManager kinetics;
    private final Map<RenderType, ModelRenderer> renderLayers = new HashMap<RenderType, ModelRenderer>();
    private final Matrix4f modelViewPartial = new Matrix4f();
    private boolean modelViewPartialReady;
    private AxisAlignedBB lightBox;

    public RenderedContraption(Contraption contraption, PlacementSimulationWorld renderWorld) {
        super(contraption, renderWorld);
        this.lighter = contraption.makeLighter();
        this.materialManager = MaterialManager.builder(CreateContexts.CWORLD).setGroupFactory(ContraptionGroup.forContraption(this)).setIgnoreOriginCoordinate(true).build();
        this.kinetics = new ContraptionInstanceManager(this, this.materialManager);
        this.buildLayers();
        if (Backend.getInstance().canUseInstancing()) {
            this.buildInstancedTiles();
            this.buildActors();
        }
    }

    public ContraptionLighter<?> getLighter() {
        return this.lighter;
    }

    public void doRenderLayer(RenderType layer, ContraptionProgram shader) {
        ModelRenderer structure = this.renderLayers.get(layer);
        if (structure != null) {
            this.setup(shader);
            structure.draw();
        }
    }

    @Override
    public void beginFrame(BeginFrameEvent event) {
        super.beginFrame(event);
        this.modelViewPartial.func_226591_a_();
        this.modelViewPartialReady = false;
        if (!this.isVisible()) {
            return;
        }
        this.kinetics.beginFrame(event.getInfo());
        Vector3d cameraPos = event.getCameraPos();
        this.lightBox = GridAlignedBB.toAABB((GridAlignedBB)this.lighter.lightVolume.getTextureVolume()).func_72317_d(-cameraPos.field_72450_a, -cameraPos.field_72448_b, -cameraPos.field_72449_c);
    }

    @Override
    public void setupMatrices(MatrixStack viewProjection, double camX, double camY, double camZ) {
        super.setupMatrices(viewProjection, camX, camY, camZ);
        if (!this.modelViewPartialReady) {
            RenderedContraption.setupModelViewPartial(this.modelViewPartial, this.getMatrices().getModel().func_227866_c_().func_227870_a_(), this.contraption.entity, camX, camY, camZ, AnimationTickHolder.getPartialTicks());
            this.modelViewPartialReady = true;
        }
    }

    void setup(ContraptionProgram shader) {
        if (!this.modelViewPartialReady || this.lightBox == null) {
            return;
        }
        shader.bind(this.modelViewPartial, this.lightBox);
        this.lighter.lightVolume.bind();
    }

    void invalidate() {
        for (ModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        this.lighter.lightVolume.delete();
        this.materialManager.delete();
        this.kinetics.invalidate();
    }

    private void buildLayers() {
        for (ModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        List blockLayers = RenderType.func_228661_n_();
        for (RenderType layer : blockLayers) {
            Supplier<IModel> layerModel = () -> new WorldModel((IBlockDisplayReader)this.renderWorld, layer, this.contraption.getBlocks().values());
            Object renderer = Backend.getInstance().compat.vertexArrayObjectsSupported() ? new ArrayModelRenderer(layerModel) : new ModelRenderer(layerModel);
            this.renderLayers.put(layer, (ModelRenderer)renderer);
        }
    }

    private void buildInstancedTiles() {
        List<TileEntity> tileEntities = this.contraption.maybeInstancedTileEntities;
        if (!tileEntities.isEmpty()) {
            for (TileEntity te : tileEntities) {
                if (!InstancedRenderRegistry.getInstance().canInstance(te.func_200662_C())) continue;
                World world = te.func_145831_w();
                BlockPos pos = te.func_174877_v();
                te.func_226984_a_((World)this.renderWorld, pos);
                this.kinetics.add(te);
                te.func_226984_a_(world, pos);
            }
        }
    }

    private void buildActors() {
        this.contraption.getActors().forEach(this.kinetics::createActor);
    }

    public static void setupModelViewPartial(Matrix4f matrix, Matrix4f modelMatrix, AbstractContraptionEntity entity, double camX, double camY, double camZ, float pt) {
        float x = (float)(MathHelper.func_219803_d((double)pt, (double)entity.field_70142_S, (double)entity.func_226277_ct_()) - camX);
        float y = (float)(MathHelper.func_219803_d((double)pt, (double)entity.field_70137_T, (double)entity.func_226278_cu_()) - camY);
        float z = (float)(MathHelper.func_219803_d((double)pt, (double)entity.field_70136_U, (double)entity.func_226281_cx_()) - camZ);
        matrix.setTranslation(x, y, z);
        matrix.func_226595_a_(modelMatrix);
    }
}

