/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.WorldAttached;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.FlwContraptionManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.SBBContraptionManager;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ContraptionRenderDispatcher {
    private static WorldAttached<ContraptionRenderManager<?>> WORLDS = new WorldAttached(SBBContraptionManager::new);
    public static final Compartment<Pair<Contraption, RenderType>> CONTRAPTION = new Compartment();

    public static void tick(World world) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        ((ContraptionRenderManager)WORLDS.get((IWorld)world)).tick();
    }

    @SubscribeEvent
    public static void beginFrame(BeginFrameEvent event) {
        ((ContraptionRenderManager)WORLDS.get((IWorld)event.getWorld())).beginFrame(event);
    }

    @SubscribeEvent
    public static void renderLayer(RenderLayerEvent event) {
        ((ContraptionRenderManager)WORLDS.get((IWorld)event.getWorld())).renderLayer(event);
    }

    @SubscribeEvent
    public static void onRendererReload(ReloadRenderersEvent event) {
        ContraptionRenderDispatcher.reset();
    }

    public static void gatherContext(GatherContextEvent e) {
        ContraptionRenderDispatcher.reset();
    }

    public static void renderFromEntity(AbstractContraptionEntity entity, Contraption contraption, IRenderTypeBuffer buffers) {
        World world = entity.field_70170_p;
        Object renderInfo = ((ContraptionRenderManager)WORLDS.get((IWorld)world)).getRenderInfo(contraption);
        ContraptionMatrices matrices = ((ContraptionRenderInfo)renderInfo).getMatrices();
        if (!matrices.isReady()) {
            return;
        }
        PlacementSimulationWorld renderWorld = ((ContraptionRenderInfo)renderInfo).renderWorld;
        ContraptionRenderDispatcher.renderTileEntities(world, renderWorld, contraption, matrices, buffers);
        if (buffers instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffers).func_228461_a_();
        }
        ContraptionRenderDispatcher.renderActors(world, renderWorld, contraption, matrices, buffers);
    }

    public static PlacementSimulationWorld setupRenderWorld(World world, Contraption c) {
        PlacementSimulationWorld renderWorld = new PlacementSimulationWorld(world);
        renderWorld.setTileEntities(c.presentTileEntities.values());
        for (Template.BlockInfo info : c.getBlocks().values()) {
            renderWorld.func_180501_a(info.field_186242_a, info.field_186243_b, 128);
        }
        renderWorld.updateLightSources();
        renderWorld.lighter.func_215575_a(Integer.MAX_VALUE, false, false);
        return renderWorld;
    }

    public static void renderTileEntities(World world, PlacementSimulationWorld renderWorld, Contraption c, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, c.specialRenderedTileEntities, matrices.getModelViewProjection(), matrices.getLight(), buffer);
    }

    protected static void renderActors(World world, PlacementSimulationWorld renderWorld, Contraption c, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.getLeft();
            MatrixStack m = matrices.getModel();
            m.func_227860_a_();
            MatrixTransformStack.of((MatrixStack)m).translate((Vector3i)blockInfo.field_186242_a);
            MovementBehaviour movementBehaviour = AllMovementBehaviours.of(blockInfo.field_186243_b);
            if (movementBehaviour != null) {
                movementBehaviour.renderInContraption(context, renderWorld, matrices, buffer);
            }
            m.func_227865_b_();
        }
    }

    public static SuperByteBuffer buildStructureBuffer(PlacementSimulationWorld renderWorld, Contraption c, RenderType layer) {
        Collection<Template.BlockInfo> values = c.getBlocks().values();
        BufferBuilder builder = ModelUtil.getBufferBuilderFromTemplate((IBlockDisplayReader)renderWorld, (RenderType)layer, values);
        return new SuperByteBuffer(builder);
    }

    public static int getLight(World world, float lx, float ly, float lz) {
        float offset;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        float block = 0.0f;
        float sky = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.func_189532_c((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    block += (float)world.func_226658_a_(LightType.BLOCK, (BlockPos)pos) / 8.0f;
                    sky += (float)world.func_226658_a_(LightType.SKY, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return LightTexture.func_228451_a_((int)((int)block), (int)((int)sky));
    }

    public static int getContraptionWorldLight(MovementContext context, PlacementSimulationWorld renderWorld) {
        return WorldRenderer.func_228421_a_((IBlockDisplayReader)renderWorld, (BlockPos)context.localPos);
    }

    public static void reset() {
        WORLDS.empty(ContraptionRenderManager::delete);
        WORLDS = Backend.getInstance().available() ? new WorldAttached(FlwContraptionManager::new) : new WorldAttached(SBBContraptionManager::new);
    }
}

