/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.press.BeltPressingCallbacks;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MechanicalPressTileEntity
extends BasinOperatingTileEntity {
    private static final Object compressingRecipesKey = new Object();
    public List<ItemStack> pressedItems = new ArrayList<ItemStack>();
    public BeltProcessingBehaviour processingBehaviour;
    public int prevRunningTicks;
    public int runningTicks;
    static final int CYCLE = 240;
    static final int ENTITY_SCAN = 10;
    int entityScanCooldown = 10;
    public boolean running;
    public Mode mode = Mode.WORLD;
    public boolean finished;
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    private static final List<ResourceLocation> RECIPE_DENY_LIST = ImmutableList.of((Object)new ResourceLocation("occultism", "spirit_trade"));

    public MechanicalPressTileEntity(TileEntityType<? extends MechanicalPressTileEntity> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltPressingCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> BeltPressingCallbacks.whenItemHeld(s, i, this));
        behaviours.add(this.processingBehaviour);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.running = compound.func_74767_n("Running");
        this.mode = Mode.values()[compound.func_74762_e("Mode")];
        this.finished = compound.func_74767_n("Finished");
        this.prevRunningTicks = this.runningTicks = compound.func_74762_e("Ticks");
        super.fromTag(state, compound, clientPacket);
        if (clientPacket) {
            NBTHelper.iterateCompoundList(compound.func_150295_c("ParticleItems", 10), c -> this.pressedItems.add(ItemStack.func_199557_a((CompoundNBT)c)));
            this.spawnParticles();
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Running", this.running);
        compound.func_74768_a("Mode", this.mode.ordinal());
        compound.func_74757_a("Finished", this.finished);
        compound.func_74768_a("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.func_218657_a("ParticleItems", (INBT)NBTHelper.writeCompoundList(this.pressedItems, IForgeItemStack::serializeNBT));
            this.pressedItems.clear();
        }
    }

    @Override
    public AxisAlignedBB makeRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(0.0, -1.5, 0.0).func_72321_a(0.0, 1.0, 0.0);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = MathHelper.func_219799_g((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        if (runningTicks < 160) {
            return (float)MathHelper.func_151237_a((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0) * this.mode.headOffset;
        }
        return MathHelper.func_76131_a((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f) * this.mode.headOffset;
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.pressedItems.clear();
        this.sendData();
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public boolean onBasin() {
        return this.mode == Mode.BASIN;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.running || this.field_145850_b == null) {
            if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
                if (this.getSpeed() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177979_c(2), TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    if (AllBlocks.BASIN.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)))) {
                        return;
                    }
                    for (ItemEntity itemEntity : this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c.func_177977_b()).func_186664_h(0.125))) {
                        ItemStack stack;
                        Optional<PressingRecipe> recipe;
                        if (!itemEntity.func_70089_S() || !itemEntity.func_233570_aj_() || !(recipe = this.getRecipe(stack = itemEntity.func_92059_d())).isPresent()) continue;
                        this.start(Mode.WORLD);
                        return;
                    }
                }
            }
            return;
        }
        if (this.field_145850_b.field_72995_K && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.getSpeed() != 0.0f) {
            if (this.inWorld()) {
                this.applyPressingInWorld();
            }
            if (this.onBasin()) {
                this.applyCompactingOnBasin();
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)).func_215695_r() == SoundType.field_185854_g) {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(this.field_145850_b, this.field_174879_c);
            } else {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.field_145850_b, this.field_174879_c, 0.5f, 0.75f + Math.abs(this.getSpeed()) / 1024.0f);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.sendData();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            if (this.onBasin() && this.matchBasinRecipe(this.currentRecipe) && this.getBasin().filter(BasinTileEntity::canContinueProcessing).isPresent()) {
                this.startProcessingBasin();
            } else {
                this.basinChecker.scheduleUpdate();
            }
            this.pressedItems.clear();
            this.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (this.field_145850_b.field_72995_K && !this.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    protected void applyCompactingOnBasin() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pressedItems.clear();
        this.applyBasinRecipe();
        Optional<BasinTileEntity> basin = this.getBasin();
        SmartInventory inputs = basin.get().getInputInventory();
        if (basin.isPresent()) {
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                ItemStack stackInSlot = inputs.func_70301_a(slot);
                if (stackInSlot.func_190926_b()) continue;
                this.pressedItems.add(stackInSlot);
            }
        }
        this.sendData();
    }

    protected void applyPressingInWorld() {
        AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177979_c(1));
        boolean bulk = MechanicalPressTileEntity.canProcessInBulk();
        this.pressedItems.clear();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (Entity entity : this.field_145850_b.func_72839_b(null, bb)) {
            if (!(entity instanceof ItemEntity) || !entity.func_70089_S() || !entity.func_233570_aj_()) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack item = itemEntity.func_92059_d();
            this.pressedItems.add(item);
            this.sendData();
            Optional<PressingRecipe> recipe = this.getRecipe(item);
            if (!recipe.isPresent()) continue;
            if (bulk || item.func_190916_E() == 1) {
                InWorldProcessing.applyRecipeOn(itemEntity, (IRecipe)recipe.get());
            } else {
                for (ItemStack result : InWorldProcessing.applyRecipeOn(ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (IRecipe)recipe.get())) {
                    ItemEntity created = new ItemEntity(this.field_145850_b, itemEntity.func_226277_ct_(), itemEntity.func_226278_cu_(), itemEntity.func_226281_cx_(), result);
                    created.func_174869_p();
                    created.func_213317_d(VecHelper.offsetRandomly(Vector3d.field_186680_a, Create.RANDOM, 0.05f));
                    this.field_145850_b.func_217376_c((Entity)created);
                }
                item.func_190918_g(1);
            }
            AllTriggers.triggerForNearbyPlayers(AllTriggers.BONK, (IWorld)this.field_145850_b, this.field_174879_c, 4);
            this.entityScanCooldown = 0;
            if (bulk) continue;
            break;
        }
    }

    public static boolean canProcessInBulk() {
        return (Boolean)AllConfigs.SERVER.recipes.bulkPressing.get();
    }

    public int getRunningTickSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return (int)MathHelper.func_219799_g((float)MathHelper.func_76131_a((float)(Math.abs(this.getSpeed()) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    protected void spawnParticles() {
        if (this.pressedItems.isEmpty()) {
            return;
        }
        if (this.mode == Mode.BASIN) {
            this.pressedItems.forEach(stack -> this.makeCompactingParticleEffect(VecHelper.getCenterOf((Vector3i)this.field_174879_c.func_177979_c(2)), (ItemStack)stack));
        }
        if (this.mode == Mode.BELT) {
            this.pressedItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vector3i)this.field_174879_c.func_177979_c(2)).func_72441_c(0.0, 0.5, 0.0), (ItemStack)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.pressedItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vector3i)this.field_174879_c.func_177979_c(1)).func_72441_c(0.0, -0.25, 0.0), (ItemStack)stack));
        }
        this.pressedItems.clear();
    }

    public void makePressingParticleEffect(Vector3d pos, ItemStack stack) {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vector3d motion = VecHelper.offsetRandomly(Vector3d.field_186680_a, this.field_145850_b.field_73012_v, 0.125f).func_216372_d(1.0, 0.0, 1.0);
            this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), pos.field_72450_a, pos.field_72448_b - 0.25, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.125, motion.field_72449_c);
        }
    }

    public void makeCompactingParticleEffect(Vector3d pos, ItemStack stack) {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vector3d motion = VecHelper.offsetRandomly(Vector3d.field_186680_a, this.field_145850_b.field_73012_v, 0.175f).func_216372_d(1.0, 0.0, 1.0);
            this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.25, motion.field_72449_c);
        }
    }

    public Optional<PressingRecipe> getRecipe(ItemStack item) {
        Optional<PressingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(this.field_145850_b, item, AllRecipeTypes.PRESSING.getType(), PressingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        pressingInv.func_70299_a(0, item);
        return AllRecipeTypes.PRESSING.find(pressingInv, this.field_145850_b);
    }

    public static <C extends IInventory> boolean canCompress(IRecipe<C> recipe) {
        NonNullList ingredients = recipe.func_192400_c();
        if (!(recipe instanceof ICraftingRecipe)) {
            return false;
        }
        IRecipeSerializer serializer = recipe.func_199559_b();
        for (ResourceLocation denied : RECIPE_DENY_LIST) {
            if (serializer == null || !denied.equals((Object)serializer.getRegistryName())) continue;
            return false;
        }
        return (Boolean)AllConfigs.SERVER.recipes.allowShapedSquareInPress.get() != false && (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.condenseIngredients((NonNullList<Ingredient>)ingredients).size() == 1;
    }

    @Override
    protected <C extends IInventory> boolean matchStaticFilters(IRecipe<C> recipe) {
        return recipe instanceof ICraftingRecipe && MechanicalPressTileEntity.canCompress(recipe) || recipe.func_222127_g() == AllRecipeTypes.COMPACTING.getType();
    }

    @Override
    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 120) {
            return;
        }
        super.startProcessingBasin();
        this.start(Mode.BASIN);
    }

    @Override
    protected void onBasinRemoved() {
        this.pressedItems.clear();
        this.running = false;
        this.runningTicks = 0;
        this.sendData();
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    protected Optional<ITriggerable> getProcessedRecipeTrigger() {
        return Optional.of(AllTriggers.PRESS_COMPACT);
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

