/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.RecipeGridHandler;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class MechanicalCrafterRenderer
extends SafeTileEntityRenderer<MechanicalCrafterTileEntity> {
    public MechanicalCrafterRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(MechanicalCrafterTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        ms.func_227860_a_();
        Direction facing = (Direction)te.func_195044_w().func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING);
        Vector3d vec = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(0.58).func_72441_c(0.5, 0.5, 0.5);
        if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING) {
            Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(te.func_195044_w());
            float progress = MathHelper.func_76131_a((float)(((float)(1000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
            vec = vec.func_178787_e(Vector3d.func_237491_b_((Vector3i)targetDirection.func_176730_m()).func_186678_a((double)(progress * 0.75f)));
        }
        ms.func_227861_a_(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        ms.func_227862_a_(0.5f, 0.5f, 0.5f);
        float yRot = AngleHelper.horizontalAngle(facing);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRot));
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
        ms.func_227865_b_();
        this.renderFast(te, partialTicks, ms, buffer, light);
    }

    public void renderItems(MechanicalCrafterTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (te.phase == MechanicalCrafterTileEntity.Phase.IDLE) {
            ItemStack stack2 = te.getInventory().func_70301_a(0);
            if (!stack2.func_190926_b()) {
                ms.func_227860_a_();
                ms.func_227861_a_(0.0, 0.0, -0.00390625);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack2, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
                ms.func_227865_b_();
            }
        } else {
            RecipeGridHandler.GroupedItems items = te.groupedItems;
            float distance = 0.5f;
            ms.func_227860_a_();
            if (te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING) {
                items = te.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = MathHelper.func_76131_a((float)(((float)(2000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = MathHelper.func_76131_a((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = MathHelper.func_76131_a((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.func_227862_a_(1.0f - lateProgress, 1.0f - lateProgress, 1.0f - lateProgress);
                Vector3d centering = new Vector3d((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).func_186678_a((double)earlyProgress);
                ms.func_227861_a_(centering.field_72450_a * 0.5, centering.field_72448_b * 0.5, 0.0);
                distance += (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
            }
            boolean onlyRenderFirst = te.phase == MechanicalCrafterTileEntity.Phase.INSERTING || te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING && te.countDown < 1000;
            float spacing = distance;
            items.grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0)) {
                    return;
                }
                ms.func_227860_a_();
                Integer x = (Integer)pair.getKey();
                Integer y = (Integer)pair.getValue();
                ms.func_227861_a_((double)((float)x.intValue() * spacing), (double)((float)y.intValue() * spacing), 0.0);
                MatrixTransformStack.of((MatrixStack)ms).nudge(x * 13 + y + te.func_174877_v().hashCode());
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
                ms.func_227865_b_();
            });
            ms.func_227865_b_();
            if (te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING) {
                items = te.groupedItems;
                float progress = MathHelper.func_76131_a((float)(((float)(1000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = MathHelper.func_76131_a((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = MathHelper.func_76131_a((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(earlyProgress * 2.0f * 360.0f));
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1.0f + (1.0f - lateProgress) * 0.125f;
                ms.func_227862_a_(upScaling, upScaling, upScaling);
                ms.func_227862_a_(downScaling, downScaling, downScaling);
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                        return;
                    }
                    Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
                });
            }
        }
    }

    public void renderFast(MechanicalCrafterTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        BlockState blockState = te.func_195044_w();
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        if (!Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            SuperByteBuffer superBuffer = PartialBufferer.get(AllBlockPartials.SHAFTLESS_COGWHEEL, blockState);
            KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light);
            superBuffer.rotateCentered(Direction.UP, (float)(((Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k() != Direction.Axis.X ? 0.0 : 1.5707963267948966));
            superBuffer.rotateCentered(Direction.EAST, 1.5707964f);
            superBuffer.renderInto(ms, vb);
        }
        Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        BlockPos pos = te.func_174877_v();
        if ((te.covered || te.phase != MechanicalCrafterTileEntity.Phase.IDLE) && te.phase != MechanicalCrafterTileEntity.Phase.CRAFTING && te.phase != MechanicalCrafterTileEntity.Phase.INSERTING) {
            SuperByteBuffer lidBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_LID, blockState);
            lidBuffer.light(light).renderInto(ms, vb);
        }
        if (MechanicalCrafterBlock.isValidTarget(te.func_145831_w(), pos.func_177972_a(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_BELT, blockState);
            SuperByteBuffer beltFrameBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_BELT_FRAME, blockState);
            if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)te.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                beltBuffer.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, (float)(textureIndex % 4) / 4.0f, 0.0f, 1);
            }
            beltBuffer.light(light).renderInto(ms, vb);
            beltFrameBuffer.light(light).renderInto(ms, vb);
        } else {
            SuperByteBuffer arrowBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_ARROW, blockState);
            arrowBuffer.light(light).renderInto(ms, vb);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, BlockState crafterState) {
        SuperByteBuffer buffer = PartialBufferer.get(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.func_177229_b(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((Direction)crafterState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered(Direction.UP, (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.EAST, (float)((double)(xRot / 180.0f) * Math.PI));
        return buffer;
    }
}

