/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.OrphanedThread;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.DebugLib;

public class LuaThread
extends LuaValue {
    public static LuaValue s_metatable;
    public static int coroutine_count;
    static long thread_orphan_check_interval;
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_SUSPENDED = 1;
    private static final int STATUS_RUNNING = 2;
    private static final int STATUS_NORMAL = 3;
    private static final int STATUS_DEAD = 4;
    private static final String[] STATUS_NAMES;
    private LuaValue env;
    private final State state;
    public LuaValue err;
    final CallStack callstack = new CallStack();
    public static final int MAX_CALLSTACK = 256;
    private static final LuaThread main_thread;
    private static LuaThread running_thread;
    public static int GC_INTERVAL;
    public Object debugState;
    private Vector children = new Vector();

    private LuaThread() {
        this.state = new State(this, null);
        this.state.status = 2;
    }

    public LuaThread(LuaValue luaValue, LuaValue luaValue2) {
        LuaValue.assert_(luaValue != null, "function cannot be null");
        this.env = luaValue2;
        this.state = new State(this, luaValue);
    }

    public int type() {
        return 8;
    }

    public String typename() {
        return "thread";
    }

    public boolean isthread() {
        return true;
    }

    public LuaThread optthread(LuaThread luaThread) {
        return this;
    }

    public LuaThread checkthread() {
        return this;
    }

    public LuaValue getmetatable() {
        return s_metatable;
    }

    public LuaValue getfenv() {
        return this.env;
    }

    public void setfenv(LuaValue luaValue) {
        this.env = luaValue;
    }

    public String getStatus() {
        return STATUS_NAMES[this.state.status];
    }

    public static LuaThread getRunning() {
        return running_thread;
    }

    public static boolean isMainThread(LuaThread luaThread) {
        return luaThread == main_thread;
    }

    public static void setGlobals(LuaValue luaValue) {
        LuaThread.running_thread.env = luaValue;
    }

    public static LuaValue getGlobals() {
        LuaValue luaValue = LuaThread.running_thread.env;
        return luaValue != null ? luaValue : LuaValue.error("LuaThread.setGlobals() not initialized");
    }

    public static final CallStack onCall(LuaFunction luaFunction) {
        CallStack callStack = LuaThread.running_thread.callstack;
        callStack.onCall(luaFunction);
        return callStack;
    }

    public static final LuaFunction getCallstackFunction(int n) {
        return LuaThread.running_thread.callstack.getFunction(n);
    }

    public static LuaValue setErrorFunc(LuaValue luaValue) {
        LuaValue luaValue2 = LuaThread.running_thread.err;
        LuaThread.running_thread.err = luaValue;
        return luaValue2;
    }

    public static Varargs yield(Varargs varargs) {
        State state = LuaThread.running_thread.state;
        if (state.function == null) {
            throw new LuaError("cannot yield main thread");
        }
        return state.lua_yield(varargs);
    }

    public Varargs resume(Varargs varargs) {
        if (this.state.status > 1) {
            return LuaValue.varargsOf(LuaValue.FALSE, (Varargs)LuaValue.valueOf("cannot resume " + STATUS_NAMES[this.state.status] + " coroutine"));
        }
        return this.state.lua_resume(this, varargs);
    }

    public void addChild(LuaThread luaThread) {
        this.children.addElement(new WeakReference<LuaThread>(luaThread));
    }

    public Varargs abandon() {
        if (this.state.status > 1) {
            return LuaValue.varargsOf(LuaValue.FALSE, (Varargs)LuaValue.valueOf("cannot abandon " + STATUS_NAMES[this.state.status] + " coroutine"));
        }
        this.state.lua_abandon(this);
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            LuaThread luaThread = (LuaThread)weakReference.get();
            if (luaThread == null || luaThread.getStatus().equals("dead")) continue;
            luaThread.abandon();
        }
        this.children.removeAllElements();
        return LuaValue.varargsOf(new LuaValue[]{LuaValue.TRUE});
    }

    static {
        coroutine_count = 0;
        thread_orphan_check_interval = 30000L;
        STATUS_NAMES = new String[]{"suspended", "suspended", "running", "normal", "dead"};
        running_thread = main_thread = new LuaThread();
        GC_INTERVAL = 30000;
    }

    public static class CallStack {
        final LuaFunction[] functions = new LuaFunction[256];
        int calls = 0;

        final void onCall(LuaFunction luaFunction) {
            this.functions[this.calls++] = luaFunction;
            if (DebugLib.DEBUG_ENABLED) {
                DebugLib.debugOnCall(running_thread, this.calls, luaFunction);
            }
        }

        public final void onReturn() {
            this.functions[--this.calls] = null;
            if (DebugLib.DEBUG_ENABLED) {
                DebugLib.debugOnReturn(running_thread, this.calls);
            }
        }

        public final int getCallstackDepth() {
            return this.calls;
        }

        LuaFunction getFunction(int n) {
            return n > 0 && n <= this.calls ? this.functions[this.calls - n] : null;
        }
    }

    static class State
    implements Runnable {
        final WeakReference lua_thread;
        final LuaValue function;
        Varargs args = LuaValue.NONE;
        Varargs result = LuaValue.NONE;
        String error = null;
        int status = 0;
        boolean abandoned = false;

        State(LuaThread luaThread, LuaValue luaValue) {
            this.lua_thread = new WeakReference<LuaThread>(luaThread);
            this.function = luaValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                Varargs varargs = this.args;
                this.args = LuaValue.NONE;
                this.result = this.function.invoke(varargs);
            }
            catch (Throwable throwable) {
                this.error = throwable.getMessage();
            }
            finally {
                this.status = 4;
                this.notify();
            }
        }

        synchronized Varargs lua_resume(LuaThread luaThread, Varargs varargs) {
            LuaThread luaThread2 = running_thread;
            try {
                running_thread = luaThread;
                this.args = varargs;
                if (this.status == 0) {
                    this.status = 2;
                    new Thread((Runnable)this, "Coroutine-" + ++coroutine_count).start();
                } else {
                    this.notify();
                }
                ((LuaThread)luaThread2).state.status = 3;
                this.status = 2;
                this.wait();
                Varargs varargs2 = this.error != null ? LuaValue.varargsOf(LuaValue.FALSE, (Varargs)LuaValue.valueOf(this.error)) : LuaValue.varargsOf(LuaValue.TRUE, this.result);
                return varargs2;
            }
            catch (InterruptedException interruptedException) {
                throw new OrphanedThread();
            }
            finally {
                running_thread = luaThread2;
                ((LuaThread)running_thread).state.status = 2;
                this.args = LuaValue.NONE;
                this.result = LuaValue.NONE;
                this.error = null;
            }
        }

        synchronized Varargs lua_yield(Varargs varargs) {
            try {
                this.result = varargs;
                this.status = 1;
                this.notify();
                do {
                    this.wait(thread_orphan_check_interval);
                    if (!this.abandoned && this.lua_thread.get() != null) continue;
                    this.status = 4;
                    throw new OrphanedThread();
                } while (this.status == 1);
                Varargs varargs2 = this.args;
                return varargs2;
            }
            catch (InterruptedException interruptedException) {
                this.status = 4;
                throw new OrphanedThread();
            }
            finally {
                this.args = LuaValue.NONE;
                this.result = LuaValue.NONE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void lua_abandon(LuaThread luaThread) {
            LuaThread luaThread2 = running_thread;
            try {
                ((LuaThread)luaThread2).state.status = 3;
                this.abandoned = true;
                if (this.status == 0) {
                    this.status = 4;
                } else {
                    this.notify();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.status = 4;
            }
            finally {
                ((LuaThread)luaThread2).state.status = 2;
                this.args = LuaValue.NONE;
                this.result = LuaValue.NONE;
                this.error = null;
            }
        }
    }
}

