/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TurtleInspectCommand
implements ITurtleCommand {
    private static final boolean FAIL_ON_AIR = true;
    private final InteractDirection m_direction;

    public TurtleInspectCommand(InteractDirection direction) {
        this.m_direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        BlockPos oldPosition;
        BlockPos newPosition;
        EnumFacing direction = this.m_direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        if (WorldUtil.isBlockInWorld(world, newPosition = WorldUtil.moveCoords(oldPosition = turtle.getPosition(), direction)) && !world.func_175623_d(newPosition)) {
            IBlockState state = world.func_180495_p(newPosition);
            Block block = state.func_177230_c();
            String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
            int metadata = block.func_176201_c(state);
            HashMap<String, Object> table = new HashMap<String, Object>();
            table.put("name", name);
            table.put("metadata", metadata);
            HashMap stateTable = new HashMap();
            for (Map.Entry entry : state.func_185899_b((IBlockAccess)world, newPosition).func_177228_b().entrySet()) {
                String propertyName = ((IProperty)entry.getKey()).func_177701_a();
                Object value = entry.getValue();
                if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                    stateTable.put(propertyName, value);
                    continue;
                }
                stateTable.put(propertyName, value.toString());
            }
            table.put("state", stateTable);
            return TurtleCommandResult.success(new Object[]{table});
        }
        return TurtleCommandResult.failure("No block to inspect");
    }
}

