/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.shared.media.items.ItemDiskLegacy;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.util.StringUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class DiskDrivePeripheral
implements IPeripheral {
    private final TileDiskDrive m_diskDrive;

    public DiskDrivePeripheral(TileDiskDrive diskDrive) {
        this.m_diskDrive = diskDrive;
    }

    @Override
    @Nonnull
    public String getType() {
        return "drive";
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"isDiskPresent", "getDiskLabel", "setDiskLabel", "hasData", "getMountPath", "hasAudio", "getAudioTitle", "playAudio", "stopAudio", "ejectDisk", "getDiskID"};
    }

    @Override
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException {
        switch (method) {
            case 0: {
                return new Object[]{this.m_diskDrive.getDiskStack() != null};
            }
            case 1: {
                IMedia media = this.m_diskDrive.getDiskMedia();
                if (media != null) {
                    return new Object[]{media.getLabel(this.m_diskDrive.getDiskStack())};
                }
                return null;
            }
            case 2: {
                String label = ArgumentHelper.optString(arguments, 0, null);
                IMedia media = this.m_diskDrive.getDiskMedia();
                if (media != null) {
                    ItemStack disk = this.m_diskDrive.getDiskStack();
                    if (media.setLabel(disk, label = StringUtil.normaliseLabel(label))) {
                        this.m_diskDrive.setDiskStack(disk);
                    } else {
                        throw new LuaException("Disk label cannot be changed");
                    }
                }
                return null;
            }
            case 3: {
                return new Object[]{this.m_diskDrive.getDiskMountPath(computer) != null};
            }
            case 4: {
                return new Object[]{this.m_diskDrive.getDiskMountPath(computer)};
            }
            case 5: {
                IMedia media = this.m_diskDrive.getDiskMedia();
                if (media != null) {
                    return new Object[]{media.getAudio(this.m_diskDrive.getDiskStack()) != null};
                }
                return new Object[]{false};
            }
            case 6: {
                IMedia media = this.m_diskDrive.getDiskMedia();
                if (media != null) {
                    return new Object[]{media.getAudioTitle(this.m_diskDrive.getDiskStack())};
                }
                return new Object[]{false};
            }
            case 7: {
                this.m_diskDrive.playDiskAudio();
                return null;
            }
            case 8: {
                this.m_diskDrive.stopDiskAudio();
                return null;
            }
            case 9: {
                this.m_diskDrive.ejectDisk();
                return null;
            }
            case 10: {
                Item item;
                ItemStack disk = this.m_diskDrive.getDiskStack();
                if (disk != null && (item = disk.func_77973_b()) instanceof ItemDiskLegacy) {
                    return new Object[]{((ItemDiskLegacy)item).getDiskID(disk)};
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void attach(@Nonnull IComputerAccess computer) {
        this.m_diskDrive.mount(computer);
    }

    @Override
    public void detach(@Nonnull IComputerAccess computer) {
        this.m_diskDrive.unmount(computer);
    }

    @Override
    public boolean equals(IPeripheral other) {
        if (other instanceof DiskDrivePeripheral) {
            DiskDrivePeripheral otherDiskDrive = (DiskDrivePeripheral)other;
            if (otherDiskDrive.m_diskDrive == this.m_diskDrive) {
                return true;
            }
        }
        return false;
    }
}

