/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.core.ServerComputer;
import javax.annotation.Nonnull;

public class ComputerPeripheral
implements IPeripheral {
    private final String m_type;
    private final ServerComputer m_computer;

    public ComputerPeripheral(String type, ServerComputer computer) {
        this.m_type = type;
        this.m_computer = computer;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.m_type;
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"turnOn", "shutdown", "reboot", "getID", "isOn", "getLabel"};
    }

    @Override
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException {
        switch (method) {
            case 0: {
                this.m_computer.turnOn();
                return null;
            }
            case 1: {
                this.m_computer.shutdown();
                return null;
            }
            case 2: {
                this.m_computer.reboot();
                return null;
            }
            case 3: {
                return new Object[]{this.m_computer.assignID()};
            }
            case 4: {
                return new Object[]{this.m_computer.isOn()};
            }
            case 5: {
                return new Object[]{this.m_computer.getLabel()};
            }
        }
        return null;
    }

    @Override
    public boolean equals(IPeripheral other) {
        return other != null && other.getClass() == this.getClass();
    }
}

