/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.HTTPRequestException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPRequest {
    private final Object m_lock = new Object();
    private final URL m_url;
    private final String m_urlString;
    private boolean m_complete;
    private boolean m_cancelled;
    private boolean m_success;
    private String m_encoding;
    private byte[] m_result;
    private boolean m_binary;
    private int m_responseCode;
    private Map<String, String> m_responseHeaders;

    public static URL checkURL(String urlString) throws HTTPRequestException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new HTTPRequestException("URL malformed");
        }
        String protocol = url.getProtocol().toLowerCase();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new HTTPRequestException("URL not http");
        }
        if (!ComputerCraft.http_whitelist.matches(url.getHost()) || ComputerCraft.http_blacklist.matches(url.getHost())) {
            throw new HTTPRequestException("Domain not permitted");
        }
        return url;
    }

    public HTTPRequest(String url, String postText, Map<String, String> headers, boolean binary) throws HTTPRequestException {
        this.m_urlString = url;
        this.m_url = HTTPRequest.checkURL(this.m_urlString);
        this.m_binary = binary;
        this.m_cancelled = false;
        this.m_complete = false;
        this.m_success = false;
        this.m_result = null;
        this.m_responseCode = -1;
        Thread thread = new Thread(() -> {
            try {
                boolean responseSuccess;
                InputStream is;
                int code;
                HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
                if (postText != null) {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                } else {
                    connection.setRequestMethod("GET");
                }
                connection.setRequestProperty("accept-charset", "UTF-8");
                if (postText != null) {
                    connection.setRequestProperty("content-type", "application/x-www-form-urlencoded; charset=utf-8");
                    connection.setRequestProperty("content-encoding", "UTF-8");
                }
                if (headers != null) {
                    for (Map.Entry header : headers.entrySet()) {
                        connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
                    }
                }
                if (postText != null) {
                    OutputStreamWriter osw;
                    OutputStream os = connection.getOutputStream();
                    try {
                        osw = new OutputStreamWriter(os, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        osw = new OutputStreamWriter(os);
                    }
                    BufferedWriter writer = new BufferedWriter(osw);
                    writer.write(postText, 0, postText.length());
                    writer.close();
                }
                if ((code = connection.getResponseCode()) >= 200 && code < 400) {
                    is = connection.getInputStream();
                    responseSuccess = true;
                } else {
                    is = connection.getErrorStream();
                    responseSuccess = false;
                }
                byte[] result = ByteStreams.toByteArray((InputStream)is);
                is.close();
                Object object = this.m_lock;
                synchronized (object) {
                    if (this.m_cancelled) {
                        this.m_complete = true;
                        this.m_success = false;
                        this.m_result = null;
                    } else {
                        this.m_complete = true;
                        this.m_success = responseSuccess;
                        this.m_result = result;
                        this.m_responseCode = connection.getResponseCode();
                        this.m_encoding = connection.getContentEncoding();
                        Joiner joiner = Joiner.on((char)',');
                        this.m_responseHeaders = new HashMap<String, String>();
                        HashMap<String, String> headers1 = this.m_responseHeaders;
                        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
                            headers1.put(header.getKey(), joiner.join((Iterable)header.getValue()));
                        }
                    }
                }
                connection.disconnect();
            }
            catch (IOException e) {
                Object object = this.m_lock;
                synchronized (object) {
                    this.m_complete = true;
                    this.m_success = false;
                    this.m_result = null;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public String getURL() {
        return this.m_urlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseCode() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_responseCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_responseHeaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSuccessful() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_success;
        }
    }

    public boolean isBinary() {
        return this.m_binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContents() {
        byte[] result;
        Object object = this.m_lock;
        synchronized (object) {
            result = this.m_result;
        }
        if (result != null) {
            return new ByteArrayInputStream(result);
        }
        return null;
    }

    public String getEncoding() {
        return this.m_encoding;
    }
}

