/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui.widgets;

import dan200.computercraft.client.gui.widgets.MousePos;
import dan200.computercraft.client.gui.widgets.WidgetContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;

public abstract class Widget
extends Gui {
    private WidgetContainer m_parent = null;
    private boolean m_visible = true;
    private int m_xPosition;
    private int m_yPosition;
    private int m_width;
    private int m_height;

    protected Widget(int x, int y, int width, int height) {
        this.m_xPosition = x;
        this.m_yPosition = y;
        this.m_width = width;
        this.m_height = height;
    }

    public WidgetContainer getRoot() {
        if (this.m_parent != null) {
            return this.m_parent.getRoot();
        }
        if (this instanceof WidgetContainer) {
            return (WidgetContainer)this;
        }
        return null;
    }

    public WidgetContainer getParent() {
        return this.m_parent;
    }

    public void setParent(WidgetContainer parent) {
        this.m_parent = parent;
    }

    public boolean isObscured() {
        if (this.m_parent != null) {
            Widget parentModalWidget = this.m_parent.getModalWidget();
            if (parentModalWidget == null) {
                return this.m_parent.isObscured();
            }
            return parentModalWidget != this;
        }
        return false;
    }

    public boolean isVisible() {
        return this.m_visible && (this.m_parent == null || this.m_parent.isVisible());
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public int getXPosition() {
        return this.m_xPosition;
    }

    public int getYPosition() {
        return this.m_yPosition;
    }

    public int getAbsoluteXPosition() {
        return this.m_xPosition + (this.m_parent != null ? this.m_parent.getAbsoluteXPosition() : 0);
    }

    public int getAbsoluteYPosition() {
        return this.m_yPosition + (this.m_parent != null ? this.m_parent.getAbsoluteYPosition() : 0);
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setPosition(int x, int y) {
        this.m_xPosition = x;
        this.m_yPosition = y;
    }

    public void resize(int width, int height) {
        this.m_width = width;
        this.m_height = height;
    }

    public void update() {
    }

    public void draw(Minecraft mc, int xOrigin, int yOrigin, int mouseX, int mouseY) {
    }

    public void drawForeground(Minecraft mc, int xOrigin, int yOrigin, int mouseX, int mouseY) {
    }

    public void modifyMousePosition(MousePos pos) {
    }

    public void handleMouseInput(int mouseX, int mouseY) {
    }

    public void handleKeyboardInput() {
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    public void keyTyped(char c, int k) {
    }

    public boolean suppressItemTooltips(Minecraft mc, int xOrigin, int yOrigin, int mouseX, int mouseY) {
        return false;
    }

    public boolean suppressKeyPress(char c, int k) {
        return false;
    }

    protected void drawFullImage(int x, int y, int w, int h) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)(x + 0), (double)(y + h), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + w), (double)(y + h), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + w), (double)(y + 0), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawT3(int x, int y, int w, int h, int u, int v, int uw, int vh) {
        int partW = uw / 3;
        super.func_73729_b(x, y, u, v, partW, vh);
        int middleBits = Math.max((w - 2 * partW) / partW, 0);
        for (int j = 0; j < middleBits; ++j) {
            super.func_73729_b(x + (j + 1) * partW, y, u + partW, v, partW, vh);
        }
        int endW = w - (middleBits + 1) * partW;
        super.func_73729_b(x + w - endW, y, u + uw - endW, v, endW, vh);
    }

    protected void drawT9(int x, int y, int w, int h, int u, int v, int uw, int vh) {
        int partH = vh / 3;
        this.drawT3(x, y, w, partH, u, v, uw, partH);
        int middleBits = Math.max((h - 2 * partH) / partH, 0);
        for (int j = 0; j < middleBits; ++j) {
            this.drawT3(x, y + (j + 1) * partH, w, partH, u, v + partH, uw, partH);
        }
        int endH = h - (middleBits + 1) * partH;
        this.drawT3(x, y + h - endH, w, endH, u, v + vh - endH, uw, endH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawInsetBorder(int x, int y, int w, int h) {
        try {
            this.func_73728_b(x, y - 1, y + h - 1, -13224394);
            this.func_73728_b(x + w - 1, y, y + h, -1);
            this.func_73730_a(x, x + w - 2, y, -13224394);
            this.func_73730_a(x + 1, x + w - 1, y + h - 1, -1);
            this.func_73730_a(x, x, y + h - 1, -7697782);
            this.func_73730_a(x + w - 1, x + w - 1, y, -7697782);
        }
        finally {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawFlatBorder(int x, int y, int w, int h, int colour) {
        colour |= 0xFF000000;
        try {
            this.func_73728_b(x, y - 1, y + h - 1, colour);
            this.func_73728_b(x + w - 1, y, y + h, colour);
            this.func_73730_a(x, x + w - 2, y, colour);
            this.func_73730_a(x + 1, x + w - 1, y + h - 1, colour);
            this.func_73730_a(x, x, y + h - 1, colour);
            this.func_73730_a(x + w - 1, x + w - 1, y, colour);
        }
        finally {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void drawTooltip(String line, int x, int y) {
        this.drawTooltip(new String[]{line}, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTooltip(String[] lines, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        int width = 0;
        for (String line : lines) {
            width = Math.max(fontRenderer.func_78256_a(line), width);
        }
        int startX = x + 12;
        int startY = y - 12;
        if (startX + width + 4 > mc.field_71462_r.field_146294_l && (startX -= width + 24) < 24) {
            startX = 24;
        }
        float oldZLevel = this.field_73735_i;
        try {
            this.field_73735_i = 300.0f;
            int height = 10 * lines.length - 2;
            int j1 = -267386864;
            this.func_73733_a(startX - 3, startY - 4, startX + width + 3, startY - 3, j1, j1);
            this.func_73733_a(startX - 3, startY + height + 3, startX + width + 3, startY + height + 4, j1, j1);
            this.func_73733_a(startX - 3, startY - 3, startX + width + 3, startY + height + 3, j1, j1);
            this.func_73733_a(startX - 4, startY - 3, startX - 3, startY + height + 3, j1, j1);
            this.func_73733_a(startX + width + 3, startY - 3, startX + width + 4, startY + height + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + height + 3 - 1, k1, l1);
            this.func_73733_a(startX + width + 2, startY - 3 + 1, startX + width + 3, startY + height + 3 - 1, k1, l1);
            this.func_73733_a(startX - 3, startY - 3, startX + width + 3, startY - 3 + 1, k1, k1);
            this.func_73733_a(startX - 3, startY + height + 2, startX + width + 3, startY + height + 3, l1, l1);
            GlStateManager.func_179097_i();
            try {
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    fontRenderer.func_175063_a(line, (float)startX, (float)(startY + i * 10), -1);
                }
            }
            finally {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179126_j();
            }
        }
        finally {
            this.field_73735_i = oldZLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawItemStack(int x, int y, @Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            try {
                Minecraft mc = Minecraft.func_71410_x();
                RenderItem renderItem = mc.func_175599_af();
                if (renderItem != null) {
                    renderItem.func_180450_b(stack, x, y);
                    renderItem.func_180453_a(mc.field_71466_p, stack, x, y, null);
                }
            }
            finally {
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawString(String s, int x, int y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            mc.field_71466_p.func_78276_b(s, x, y, color);
        }
        finally {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected int getStringWidth(String s) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71466_p.func_78256_a(s);
    }

    protected void playClickSound() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

