/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiTurtle
extends GuiContainer {
    private static final ResourceLocation background = new ResourceLocation("computercraft", "textures/gui/turtle.png");
    private static final ResourceLocation backgroundAdvanced = new ResourceLocation("computercraft", "textures/gui/turtle_advanced.png");
    protected World m_world;
    protected ContainerTurtle m_container;
    protected final ComputerFamily m_family;
    protected final ITurtleAccess m_turtle;
    protected final IComputer m_computer;
    protected WidgetTerminal m_terminalGui;

    public GuiTurtle(World world, InventoryPlayer inventoryplayer, TileTurtle turtle) {
        this(world, turtle, new ContainerTurtle((IInventory)inventoryplayer, turtle.getAccess()));
    }

    protected GuiTurtle(World world, TileTurtle turtle, ContainerTurtle container) {
        super((Container)container);
        this.m_world = world;
        this.m_container = container;
        this.m_family = turtle.getFamily();
        this.m_turtle = turtle.getAccess();
        this.m_computer = turtle.createComputer();
        this.field_146999_f = 254;
        this.field_147000_g = 217;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.m_terminalGui = new WidgetTerminal((this.field_146294_l - this.field_146999_f) / 2 + 8, (this.field_146295_m - this.field_147000_g) / 2 + 8, 39, 13, () -> this.m_computer, 2, 2, 2, 2);
        this.m_terminalGui.setAllowFocusLoss(false);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.m_terminalGui.update();
    }

    protected void func_73869_a(char c, int k) throws IOException {
        if (k == 1) {
            super.func_73869_a(c, k);
        } else {
            this.m_terminalGui.keyTyped(c, k);
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.m_terminalGui.mouseClicked(x, y, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.m_terminalGui.handleMouseInput(x, y);
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        this.m_terminalGui.handleKeyboardInput();
    }

    protected void drawSelectionSlot(boolean advanced) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int slot = this.m_container.getSelectedSlot();
        if (slot >= 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int slotX = slot % 4;
            int slotY = slot / 4;
            this.field_146297_k.func_110434_K().func_110577_a(advanced ? backgroundAdvanced : background);
            this.func_73729_b(x + this.m_container.m_turtleInvStartX - 2 + slotX * 18, y + this.m_container.m_playerInvStartY - 2 + slotY * 18, 0, 217, 24, 24);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        boolean advanced = this.m_family == ComputerFamily.Advanced;
        this.m_terminalGui.draw(Minecraft.func_71410_x(), 0, 0, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(advanced ? backgroundAdvanced : background);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawSelectionSlot(advanced);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

