/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.network.ByteBufHelper;
import cofh.lib.transport.ClientEnderChannelRegistry;
import cofh.lib.transport.EnderRegistry;
import cofh.lib.transport.IEnderChannelRegistry;
import cofh.lib.transport.ServerEnderChannelRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;

public class RegistryEnderAttuned {
    static EnderRegistry registry;
    static ServerEnderChannelRegistry serverChannels;
    static ClientEnderChannelRegistry clientChannels;
    static final String dummy;

    public static void initialize() {
        PacketHandler.instance.registerPacket(Packet.class);
    }

    public static void createClientRegistry() {
        clientChannels = new ClientEnderChannelRegistry(){

            @Override
            public String setFrequency(String string, int n, String string2) {
                if (string != dummy) {
                    PacketHandler.sendToServer(new Packet(this.hostedChannel, n, string2));
                }
                return super.setFrequency(this.hostedChannel, n, string2);
            }

            @Override
            public String removeFrequency(String string, int n) {
                if (string != dummy) {
                    PacketHandler.sendToServer(new Packet(this.hostedChannel, n));
                }
                return super.removeFrequency(this.hostedChannel, n);
            }
        };
    }

    public static void createServerRegistry() {
        serverChannels = new ServerEnderChannelRegistry(new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/EnderFrequencies.cfg")));
        registry = new EnderRegistry(new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/EnderDestinations.cfg")));
    }

    static void save() {
        registry.save();
        serverChannels.save();
    }

    public static EnderRegistry getRegistry() {
        return registry;
    }

    public static IEnderChannelRegistry getChannels(boolean bl) {
        return bl ? serverChannels : clientChannels;
    }

    public static void requestChannelList(String string) {
        PacketHandler.sendToServer(new Packet(string));
    }

    public static void updateChannelFrequency(EntityPlayer entityPlayer, String string, int n, String string2) {
        PacketHandler.sendTo((PacketBase)new Packet(string, n, string2), entityPlayer);
    }

    public static void removeChannelFrequency(EntityPlayer entityPlayer, String string, int n) {
        PacketHandler.sendTo((PacketBase)new Packet(string, n), entityPlayer);
    }

    static {
        dummy = new String();
    }

    public static class Packet
    extends PacketBase {
        public ByteBuf data;

        public Packet() {
        }

        private Packet(String string) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(0);
            ByteBufHelper.writeString(string, this.data);
        }

        private Packet(String string, int n) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(2);
            ByteBufHelper.writeString(string, this.data);
            ByteBufHelper.writeVarInt(n, this.data);
        }

        private Packet(String string, int n, String string2) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(1);
            ByteBufHelper.writeString(string, this.data);
            ByteBufHelper.writeVarInt(n, this.data);
            ByteBufHelper.writeString(string2, this.data);
        }

        private Packet(String string, Void void_) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(0);
            this.data.writeBytes(serverChannels.getFrequencyData(string));
        }

        @Override
        public void encodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
            byteBuf.writeBytes(this.data);
        }

        @Override
        public void decodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
            this.data = byteBuf;
        }

        @Override
        public void handleClientSide(EntityPlayer entityPlayer) {
            switch (this.data.readByte()) {
                case 0: {
                    clientChannels.readFrequencyData(this.data);
                    break;
                }
                case 1: {
                    if (!clientChannels.getChannelName().equals(ByteBufHelper.readString(this.data))) break;
                    clientChannels.setFrequency(dummy, ByteBufHelper.readVarInt(this.data), ByteBufHelper.readString(this.data));
                    break;
                }
                case 2: {
                    if (!clientChannels.getChannelName().equals(ByteBufHelper.readString(this.data))) break;
                    clientChannels.removeFrequency(dummy, ByteBufHelper.readVarInt(this.data));
                }
            }
        }

        @Override
        public void handleServerSide(EntityPlayer entityPlayer) {
            switch (this.data.readByte()) {
                case 0: {
                    PacketHandler.sendTo((PacketBase)new Packet(ByteBufHelper.readString(this.data), null), entityPlayer);
                    break;
                }
                case 1: {
                    serverChannels.setFrequency(ByteBufHelper.readString(this.data), ByteBufHelper.readVarInt(this.data), ByteBufHelper.readString(this.data));
                    break;
                }
                case 2: {
                    serverChannels.removeFrequency(ByteBufHelper.readString(this.data), ByteBufHelper.readVarInt(this.data));
                }
            }
        }
    }
}

