/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.texture;

import codechicken.lib.texture.SpriteSheetManager;
import codechicken.lib.texture.TextureSpecial;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureFX {
    public int[] imageData;
    public int tileSizeBase = 16;
    public int tileSizeSquare = 256;
    public int tileSizeMask = 15;
    public int tileSizeSquareMask = 255;
    public boolean anaglyphEnabled;
    public TextureSpecial texture;

    public TextureFX(int spriteIndex, SpriteSheetManager.SpriteSheet sheet) {
        this.texture = sheet.bindTextureFX(spriteIndex, this);
    }

    public TextureFX(int size, String name) {
        this.texture = new TextureSpecial(name).blank(size).selfRegister().addTextureFX(this);
    }

    public TextureFX setAtlas(int index) {
        this.texture.atlasIndex = index;
        return this;
    }

    public void setup() {
        this.imageData = new int[this.tileSizeSquare];
    }

    public void onTextureDimensionsUpdate(int width, int height) {
        if (width != height) {
            throw new IllegalArgumentException("Non-Square textureFX not supported (" + width + ":" + height + ")");
        }
        this.tileSizeBase = width;
        this.tileSizeSquare = this.tileSizeBase * this.tileSizeBase;
        this.tileSizeMask = this.tileSizeBase - 1;
        this.tileSizeSquareMask = this.tileSizeSquare - 1;
        this.setup();
    }

    public void update() {
        this.anaglyphEnabled = Minecraft.func_71410_x().field_71474_y.field_74337_g;
        this.onTick();
    }

    public void onTick() {
    }

    public boolean changed() {
        return true;
    }
}

