#version 120
//Horizontal bilateral blur for ambient

/*--------------------------------*/
varying vec2 texcoord;
uniform sampler2D depthtex1;
uniform sampler2D colortex3;
uniform float near;
uniform float far;
uniform vec2 texelSize;
float ld(float dist) {
    return (2.0 * near) / (far + near - dist * (far - near));
}


vec3 ssaoVL_blur(vec2 tex, vec2 dir,float cdepth)
{
	

	vec2 step = dir*texelSize;



	
	vec3 res = vec3(0.0);
	vec3 total_weights = vec3(0.);
	

		vec3 sp = texture2D(colortex3, tex - 2.0*step).xyz;
		float linD = abs(cdepth-ld(texture2D(depthtex1,tex - 2.0*step).x)*far);
		float ssaoThresh = linD < 0.15 ? 1.0 : 0.;
		float weight = (ssaoThresh);
		res += sp * weight;
		total_weights += weight;
	
		sp = texture2D(colortex3, tex - step).xyz;
		linD = abs(cdepth-ld(texture2D(depthtex1,tex - step).x)*far);
		ssaoThresh = linD < 0.15 ? 1.0 : 0.;
		weight = (ssaoThresh);
		res += sp * weight;
		total_weights += weight;
		
		sp = texture2D(colortex3, tex + step).xyz;
		linD = abs(cdepth-ld(texture2D(depthtex1,tex + step).x)*far);
		ssaoThresh = linD < 0.15 ? 1.0 : 0.;
		weight = (ssaoThresh);
		res += sp * weight;
		total_weights += weight;
		
		sp = texture2D(colortex3, tex + 2.*step).xyz;
		linD = abs(cdepth-ld(texture2D(depthtex1,tex + 2.*step).x)*far);
		ssaoThresh = linD < 0.15 ? 1.0 : 0.;
		weight =(ssaoThresh);
		res += sp * weight;
		total_weights += weight;
		

		
		res += texture2D(colortex3, texcoord).xyz;
		total_weights += 1.;
		
	res /= total_weights;

	return res;
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {
	
float Depth = texture2D(depthtex1, texcoord).x;


vec3 blur = vec3(0.);
if (Depth < 1.0){
	Depth = ld(Depth);
	blur = ssaoVL_blur(texcoord,vec2(1.0,0.0),Depth*far);
}

/* DRAWBUFFERS:3 */
	gl_FragData[0] = vec4(blur.xyz,1.0);

}
