#version 400 compatibility
//Ambient shading (minecraft lightmap + ssao + GI)
#extension GL_EXT_gpu_shader4 : enable



#define MIN_LIGHT_AMOUNT 1.0 //[0.0 0.5 1.0 1.5 2.0 3.0 4.0 5.0]

#define TORCH_AMOUNT 1.0 //[0.0 0.5 0.75 1.0 1.2 1.4 1.6 1.8 2.0]
#define TORCH_R 1.0 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define TORCH_G 0.42 //[0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.42 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define TORCH_B 0.11 //[0.0 0.05 0.1 0.11 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
const int shadowMapResolution = 4096; //[512 768 1024 1536 2048 3172 4096 8192]

varying vec2 texcoord;
//ambient sky light is integrated in vertex shader for each block side
varying vec3 ambientUp;
varying vec3 ambientLeft;
varying vec3 ambientRight;
varying vec3 ambientB;
varying vec3 ambientF;
varying vec3 ambientDown;
//main light source color (rgb),used light source(1=sun,-1=moon)
varying vec4 lightCol;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D colortex4;


uniform vec3 sunColor;
uniform vec3 nsunColor;

uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform mat4 shadowProjectionInverse;
uniform float far;
uniform float near;
uniform float frameTimeCounter;
uniform float sunIntensity;
uniform float skyIntensity;
uniform float skyIntensityNight;
uniform float rainStrength;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform vec2 texelSize;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform int framemod8;
		const vec2[8] offsets = vec2[8](vec2(1./8.,-3./8.),
									vec2(-1.,3.)/8.,
									vec2(5.0,1.)/8.,
									vec2(-3,-5.)/8.,
									vec2(-5.,5.)/8.,
									vec2(-7.,-1.)/8.,
									vec2(3,7.)/8.,
									vec2(7.,-7.)/8.);
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)


vec3 toScreenSpace(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}

vec3 toWorldSpace(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    return p3;
}

vec3 toWorldSpaceCamera(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    return p3 + cameraPosition;
}

vec3 toShadowSpace(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    p3 = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
    return p3;
}

vec3 toShadowSpaceProjected(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    p3 = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
    p3 = diagonal3(shadowProjection) * p3 + shadowProjection[3].xyz;

    return p3;
}


vec3 sunVec = normalize(mat3(gbufferModelViewInverse) *sunPosition);
#include "lib/color_transforms.glsl"
#include "lib/sky_gradient.glsl"
#include "lib/clouds.glsl"
#include "lib/stars.glsl"
vec3 normVec (vec3 vec){
	return vec*inversesqrt(dot(vec,vec));
}
float lengthVec (vec3 vec){
	return sqrt(dot(vec,vec));
}
#define fsign(a)  (clamp((a)*1e35,0.,1.)*2.-1.)
float triangularize(float dither)
{
    float center = dither*2.0-1.0;
    dither = center*inversesqrt(abs(center));
    dither = max(-1.0,dither); 
    return dither-fsign(center);
}
float interleaved_gradientNoise(float temp){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y)+temp);
}
vec3 fp10Dither(vec3 color,float dither){
	const vec3 mantissaBits = vec3(6.,6.,5.);
	vec3 exponent = floor(log2(color));
	return color + dither*exp2(-mantissaBits)*exp2(exponent);
}

const vec2 shadowOffsets[8] = vec2[8](vec2( -0.7071,  0.7071 ),
									  vec2( -0.0000, -0.8750 ),
								 	  vec2(  0.5303,  0.5303 ),
									  vec2( -0.6250, -0.0000 ),
									  vec2(  0.3536, -0.3536 ),
									  vec2( -0.0000,  0.3750 ),
									  vec2( -0.1768, -0.1768 ),
									  vec2( 0.1250,  0.0000 ));

									
float facos(float sx){
    float x = clamp(abs( sx ),0.,1.);
    float a = sqrt( 1. - x ) * ( -0.16882 * x + 1.56734 );
    return sx > 0. ? a : pi - a;
}		
vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}
#define SHADOW_MAP_BIAS 0.8
float calcDistort(vec2 worlpos){
	
	vec2 pos = abs(worlpos * 1.165);
	vec2 posSQ = pos*pos;
	
	float distb = pow(posSQ.x*posSQ.x*posSQ.x + posSQ.y*posSQ.y*posSQ.y, 1.0 / 6.0);
	return 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
}		
vec2 decodeVec2(float a){
    const vec2 constant1 = 65535. / vec2( 256., 65536.);
    const float constant2 = 256. / 255.;
    return fract( a * constant1 ) * constant2 ;
}	
float linZ(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		
	// l = (2*n)/(f+n-d(f-n))
	// f+n-d(f-n) = 2n/l
	// -d(f-n) = ((2n/l)-f-n)
	// d = -((2n/l)-f-n)/(f-n)
	
}
float invLinZ (float lindepth){
	return -((2.0*near/lindepth)-far-near)/(far-near);
}

vec3 toClipSpace3(vec3 viewSpacePosition) {
    return projMAD(gbufferProjection, viewSpacePosition) / -viewSpacePosition.z * 0.5 + 0.5;
}

float w0(float a)
{
    return (1.0/6.0)*(a*(a*(-a + 3.0) - 3.0) + 1.0);
}

float w1(float a)
{
    return (1.0/6.0)*(a*a*(3.0*a - 6.0) + 4.0);
}

float w2(float a)
{
    return (1.0/6.0)*(a*(a*(-3.0*a + 3.0) + 3.0) + 1.0);
}

float w3(float a)
{
    return (1.0/6.0)*(a*a*a);
}

float g0(float a)
{
    return w0(a) + w1(a);
}

float g1(float a)
{
    return w2(a) + w3(a);
}

float h0(float a)
{
    return -1.0 + w1(a) / (w0(a) + w1(a));
}

float h1(float a)
{
    return 1.0 + w3(a) / (w2(a) + w3(a));
}
float bayer2(vec2 a){
	a = floor(a);
    return fract(dot(a,vec2(0.5,a.y*0.75)));
}
float hash11(float p)
{
	vec3 p3  = fract(vec3(p) * 0.1031);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}
#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  fract(bayer8( .5*(a))*.25+bayer2(a)+hash11(frameTimeCounter))
vec4 texture2D_bicubic(sampler2D tex, vec2 uv)
{
	vec4 texelSize = vec4(texelSize,1.0/texelSize);
	
	uv = uv*texelSize.zw;
	vec2 iuv = floor( uv );
	vec2 fuv = fract( uv );

    float g0x = g0(fuv.x);
    float g1x = g1(fuv.x);
    float h0x = h0(fuv.x);
    float h1x = h1(fuv.x);
    float h0y = h0(fuv.y);
    float h1y = h1(fuv.y);

	vec2 p0 = (vec2(iuv.x + h0x, iuv.y + h0y) - 0.5) * texelSize.xy;
	vec2 p1 = (vec2(iuv.x + h1x, iuv.y + h0y) - 0.5) * texelSize.xy;
	vec2 p2 = (vec2(iuv.x + h0x, iuv.y + h1y) - 0.5) * texelSize.xy;
	vec2 p3 = (vec2(iuv.x + h1x, iuv.y + h1y) - 0.5) * texelSize.xy;
	
    return g0(fuv.y) * (g0x * texture2D(tex, p0)  +
                        g1x * texture2D(tex, p1)) +
           g1(fuv.y) * (g0x * texture2D(tex, p2)  +
                        g1x * texture2D(tex, p3));
}	
vec2 tapLocation(int sampleNumber, float spinAngle,int nb,float nbRot)
{
    float alpha =  (float(sampleNumber + spinAngle/6.28) /nb);
    float angle = alpha * (nbRot * 6.28) + spinAngle;

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);
	
    return vec2(cos_v, sin_v)*ssR;
}

vec3 get_GI(vec2 tc,vec3 normal,float noise) {
	float Depth = texture2D(depthtex1, texcoord).x;
	vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord,Depth,1.0) * 2.0 - 1.0);
	fragpos /= fragpos.w;	

	
	vec4 worldposition = gbufferModelViewInverse * vec4(fragpos);
	vec3 wposr = worldposition.xyz+cameraPosition;
	worldposition = shadowModelView * worldposition;
	vec3 wpos2 = worldposition.xyz;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;

	
	
	worldposition = worldposition*0.5+0.5;

		vec3 t1 = mat3(shadowModelView) * normal;
		
		vec3 projNormal = t1.rgb;

		vec3 gi = vec3(0.);


	    noise = noise*2.0*3.14159265359;


		
		const int nbSamples = 12;
		
		
		//
		//d = 2^n * df
		//ln(d/df)/ln(2) = n
		
		for (int i = 0; i < nbSamples;i++)  {

				vec2 offset = tapLocation(i,noise,nbSamples,2.0);
				
				vec2 TC = (worldposition.xy+offset*0.07120768229);
				
				const float gi_size = 50.0;
				vec4 shadowSampleLowRes = texelFetch2D(colortex4,ivec2(TC*512.),0);
				float sampleDepth = shadowSampleLowRes.a+1/1000.; 
				vec3 sAlbedo = pow(shadowSampleLowRes.rgb,vec3(2.2));	
	
				vec3 S1 = vec3(TC,sampleDepth);
				vec4 shadowPos = shadowProjectionInverse * ((vec4(S1,1.0)*2.0-1.0)*vec4(1.0,1.0,3.0,1.0));				
				vec3 V = shadowPos.xyz-wpos2;
				
				float NdotS = clamp(dot(projNormal,normalize(V)),0.0,1.0)*0.9+0.1;
				float dist = max(length(V),3.);
				float fallof1 = clamp(1.0 - pow(dist/gi_size,4.0),0.0,1.0);
				float Scoef = fallof1*fallof1/(dist*dist);
				float weight = i/nbSamples+noise/nbSamples;
				gi += NdotS*sAlbedo*Scoef*weight;

			}
			


				
				return gi*2.;
}	

vec2 tapLocation(int sampleNumber, float spinAngle,int nb, float nbRot,float r0)
{
    float alpha = (float(sampleNumber*1.0f + r0) * (1.0 / (nb)));
    float angle = alpha * (nbRot * 6.28) + spinAngle;

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);
	
    return vec2(cos_v, sin_v)*ssR;
}


void ssao(inout float occlusion,  vec2 tex,vec3 fragpos,float mulfov,float dither,vec3 normal)
{
	const float tan70 = tan(70.*3.14/180.);
	float mulfov2 = gbufferProjection[1][1]/tan70; 

	const float PI = 3.14159265;
	const float samplingRadius = 0.712;
	vec2 radius = clamp(0.712/ (-fragpos.zz),6.0/vec2(viewWidth,viewHeight),vec2(0.5));
	float angle_thresh = 0.05;


	float noise2 = dither;
	float noise = noise2*(PI*2.);

	vec2 rd = vec2(radius.x,radius.y*aspectRatio)*mulfov2*vec2(viewWidth,viewHeight);
	//pre-rotate direction
	float n = 0.;

	occlusion = 0.0;
	ivec2 pos = ivec2(gl_FragCoord.xy);
	vec2 acc = -vec2(offsets[framemod8])*texelSize*0.5;
	
	for (int j = 0; j < 9 ;j++) {
	
		vec2 sp = tapLocation(j,noise,9,3.,noise2);
			vec2 sampleOffset = sp*rd;	
			ivec2 offset = ivec2(gl_FragCoord.xy + sampleOffset); 
			if (offset.x > 0. && offset.y > 0. && offset.x < viewWidth && offset.y < viewHeight ) {
			vec3 t0 = toScreenSpace(vec3(offset/vec2(viewWidth,viewHeight)+acc,texelFetch(depthtex1,offset,0).x));

			vec3 vec = t0.xyz - fragpos;
			float dsquared = dot(vec,vec);
			float NdotV = clamp(dot(vec*inversesqrt(dsquared), normal)-angle_thresh,0.,1.);

			occlusion += NdotV * clamp(1.0-dsquared*0.5,0.0,1.0);	

			}
	}

	

		occlusion = clamp(1.0-occlusion/9.*2.1,0.,1.0);

}


void main() {

	
	float z = texture2D(depthtex1,texcoord).x;

	vec3 color = vec3(0.);
	//land
	if (z<1.0) {
			vec2 tempOffset=offsets[framemod8];
	float noise = bayer16(gl_FragCoord.xy);

	vec3 fragpos = toScreenSpace(vec3(texcoord-vec2(tempOffset)*texelSize*0.5,z));
	vec3 p3 = mat3(gbufferModelViewInverse) * fragpos;
	vec3 np3 = normVec(p3);

		p3 += gbufferModelViewInverse[3].xyz;
		
		vec4 data = texture2D(colortex1,texcoord);
		vec4 dataUnpacked0 = vec4(decodeVec2(data.x),decodeVec2(data.y));
		vec4 dataUnpacked1 = vec4(decodeVec2(data.z),decodeVec2(data.w));
		
		vec3 normal = mat3(gbufferModelViewInverse) * decode(dataUnpacked0.yw);

		vec2 lightmap = dataUnpacked1.yz;
		lightmap.x *= lightmap.x;
		bool translucent = abs(dataUnpacked1.w-0.5) <0.01;
		
		float NdotL = lightCol.a*dot(normal,sunVec);
		
		float diffuseSun = clamp(NdotL,0.,1.0);
		float shading = 1.0;
		


		//strong highlight near lightsource + soft light
		float torch_lightmap = ((lightmap.x*lightmap.x)*(lightmap.x*lightmap.x))*(lightmap.x*20.)+lightmap.x;

		
		//apply ambient light, which have been computed for each block side
		//interpolate between sides for non-blocks
		
		//make sure that the sum of the coefficients is equal to 1
		vec3 ambientCoefs = normal/dot(abs(normal),vec3(1.));
		
		vec3 ambientLight = ambientUp*clamp(ambientCoefs.y,0.,1.);	
		ambientLight += ambientDown*clamp(-ambientCoefs.y,0.,1.);
		ambientLight += ambientRight*clamp(ambientCoefs.x,0.,1.);
		ambientLight += ambientLeft*clamp(-ambientCoefs.x,0.,1.);
		ambientLight += ambientB*clamp(ambientCoefs.z,0.,1.);
		ambientLight += ambientF*clamp(-ambientCoefs.z,0.,1.);	
		
		float ao= 1.0;
		ssao(ao,texcoord,fragpos,1.0,noise,decode(dataUnpacked0.yw));
		ambientLight += lightCol.rgb*get_GI(texcoord,normal,noise)*5.;


		
		//combine all light sources (direct+ambient+torch+minimum ambient)
		color = pow(lightmap.y,2.4)*ao*(ambientLight*(1.06+float(translucent)*0.1))+ vec3(TORCH_R,TORCH_G,TORCH_B)*torch_lightmap*ao*0.08*TORCH_AMOUNT+0.0006*ao;		
		//color = lightCol.rgb*get_GI(texcoord,normal,noise)*8.*ao;


					
	}
	//dither output to avoid banding
	gl_FragData[0] = vec4(color*10.,1.);
/* DRAWBUFFERS:3 */
}
