#define DRAW_SUN //if not using custom sky
#define SKY_BRIGHTNESS_DAY 1.0 //[0.0 0.5 0.75 1. 1.2 1.4 1.6 1.8 2.0]
#define SKY_BRIGHTNESS_NIGHT 1.0 //[0.0 0.5 0.75 1. 1.2 1.4 1.6 1.8 2.0]

vec3 drawSun(float cosY, float sunInt,vec3 nsunlight,vec3 inColor){
	#ifdef DRAW_SUN
	cosY=clamp(cosY,0.,1.0);
	return inColor+nsunlight*10000.*sunInt*pow(clamp(cosY*cosY+0.0004,0.0,1.0),9000.)*(1.0-rainStrength*0.999);
	#endif
	#ifndef DRAW_SUN
	return inColor;
	#endif
}


vec3 getSkyColorLut(vec3 sVector, vec3 sunVec,float cosT,sampler2D lut) {
	const vec3 moonlight = vec3(0.8, 1.1, 1.4) * 0.06;

	float mCosT = clamp(cosT,0.0,1.);
	float cosY = dot(sunVec,sVector);
	float x = ((cosY*cosY)*(cosY*0.5*256.)+0.5*256.+18.+0.5)*texelSize.x;
	float y = (mCosT*256.+1.0+0.5)*texelSize.y;

	return texture2D(lut,vec2(x,y)).rgb;


}
