/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registrars;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.chiseling.metadata.SimpleMetadataKey;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistry;
import mod.chiselsandbits.platforms.core.registries.deferred.ICustomRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModMetadataKeys {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ICustomRegistrar<IMetadataKey<?>> KEY_REGISTRAR = ICustomRegistrar.create(IMetadataKey.class, "chiselsandbits");
    public static final Supplier<IChiselsAndBitsRegistry<IMetadataKey<?>>> REGISTRY_SUPPLIER = KEY_REGISTRAR.makeRegistry(IChiselsAndBitsRegistry.Builder::simple);
    public static final Supplier<IMetadataKey<Vec3>> ANCHOR = KEY_REGISTRAR.register("anchor", () -> new SimpleMetadataKey<Vec3>(){

        @Override
        public Vec3 snapshot(Vec3 value) {
            return new Vec3(value.m_7096_(), value.m_7098_(), value.m_7094_());
        }
    });
    public static final Supplier<IMetadataKey<Vec3>> END_POINT = KEY_REGISTRAR.register("endpoint", () -> new SimpleMetadataKey<Vec3>(){

        @Override
        public Vec3 snapshot(Vec3 value) {
            return new Vec3(value.m_7096_(), value.m_7098_(), value.m_7094_());
        }
    });
    public static final Supplier<IMetadataKey<Direction>> TARGETED_SIDE = KEY_REGISTRAR.register("targeted_side", () -> new SimpleMetadataKey<Direction>(){

        @Override
        public Direction snapshot(Direction value) {
            return value;
        }
    });
    public static final Supplier<IMetadataKey<Set<Vec3i>>> VALID_POSITIONS = KEY_REGISTRAR.register("valid_positions", () -> new SimpleMetadataKey<Set<Vec3i>>(){

        @Override
        public Set<Vec3i> snapshot(Set<Vec3i> value) {
            return value.stream().map(val -> new Vec3i(val.m_123341_(), val.m_123342_(), val.m_123343_())).collect(Collectors.toSet());
        }
    });
    public static final Supplier<IMetadataKey<BlockPos>> TARGETED_BLOCK = KEY_REGISTRAR.register("targeted_block", () -> new SimpleMetadataKey<BlockPos>(){

        @Override
        public BlockPos snapshot(BlockPos value) {
            return value;
        }
    });

    private ModMetadataKeys() {
        throw new IllegalStateException("Can not instantiate an instance of: ModMetadataKeys. This is a utility class");
    }

    public static void onModConstruction() {
        LOGGER.info("Loaded metadata key configuration.");
    }
}

