/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.platforms.core.client.rendering.type;

import java.util.Optional;
import java.util.function.Predicate;
import mod.chiselsandbits.platforms.core.client.rendering.IRenderingManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public interface IRenderTypeManager {
    public static IRenderTypeManager getInstance() {
        return IRenderingManager.getInstance().getRenderTypeManager();
    }

    @NotNull
    public Optional<RenderType> getCurrentRenderType();

    public void setCurrentRenderType(RenderType var1);

    public boolean canRenderInType(BlockState var1, RenderType var2);

    public boolean canRenderInType(FluidState var1, RenderType var2);

    public void setPossibleRenderTypesFor(Block var1, RenderType var2, Predicate<RenderType> var3);

    default public void setPossibleRenderTypesFor(Block block, RenderType defaultRenderType) {
        this.setPossibleRenderTypesFor(block, defaultRenderType, type -> type == defaultRenderType);
    }
}

