/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.client.key;

import com.mojang.blaze3d.platform.InputConstants;
import mod.chiselsandbits.forge.platform.client.key.ForgeKeyConflictContextPlatformDelegate;
import mod.chiselsandbits.forge.platform.client.key.PlatformKeyConflictContextForgeDelegate;
import mod.chiselsandbits.platforms.core.client.key.IKeyBindingManager;
import mod.chiselsandbits.platforms.core.client.key.IKeyConflictContext;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;

public class ForgeKeyBindingManager
implements IKeyBindingManager {
    private static final ForgeKeyBindingManager INSTANCE = new ForgeKeyBindingManager();

    public static ForgeKeyBindingManager getInstance() {
        return INSTANCE;
    }

    private ForgeKeyBindingManager() {
    }

    @Override
    public void register(KeyMapping mapping) {
        ClientRegistry.registerKeyBinding((KeyMapping)mapping);
    }

    @Override
    public IKeyConflictContext getGuiKeyConflictContext() {
        return new ForgeKeyConflictContextPlatformDelegate((net.minecraftforge.client.settings.IKeyConflictContext)KeyConflictContext.GUI);
    }

    @Override
    public KeyMapping createNew(String translationKey, IKeyConflictContext keyConflictContext, InputConstants.Type inputType, int key, String groupTranslationKey) {
        return new KeyMapping(translationKey, (net.minecraftforge.client.settings.IKeyConflictContext)new PlatformKeyConflictContextForgeDelegate(keyConflictContext), inputType, key, groupTranslationKey);
    }

    @Override
    public KeyMapping createNew(String translationKey, IKeyConflictContext keyConflictContext, mod.chiselsandbits.platforms.core.client.key.KeyModifier keyModifier, InputConstants.Type inputType, int key, String groupTranslationKey) {
        return new KeyMapping(translationKey, (net.minecraftforge.client.settings.IKeyConflictContext)new PlatformKeyConflictContextForgeDelegate(keyConflictContext), ForgeKeyBindingManager.makePlatformSpecific(keyModifier), inputType, key, groupTranslationKey);
    }

    @Override
    public boolean isKeyConflictOfActive(KeyMapping keybinding) {
        return keybinding.getKeyConflictContext().isActive();
    }

    @Override
    public boolean isKeyModifierActive(KeyMapping keybinding) {
        return keybinding.getKeyModifier().isActive(keybinding.getKeyConflictContext());
    }

    private static KeyModifier makePlatformSpecific(mod.chiselsandbits.platforms.core.client.key.KeyModifier keyModifier) {
        return switch (keyModifier) {
            default -> throw new IncompatibleClassChangeError();
            case mod.chiselsandbits.platforms.core.client.key.KeyModifier.CONTROL -> KeyModifier.CONTROL;
            case mod.chiselsandbits.platforms.core.client.key.KeyModifier.SHIFT -> KeyModifier.SHIFT;
            case mod.chiselsandbits.platforms.core.client.key.KeyModifier.ALT -> KeyModifier.ALT;
        };
    }
}

