/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.client.color;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import mod.chiselsandbits.platforms.core.client.rendering.IColorManager;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeColorManager
implements IColorManager {
    private static final ForgeColorManager INSTANCE = new ForgeColorManager();
    private final List<Consumer<IColorManager.IBlockColorSetter>> blockColorSetters = Lists.newArrayList();
    private final List<Consumer<IColorManager.IItemColorSetter>> itemColorSetters = Lists.newArrayList();

    public static ForgeColorManager getInstance() {
        return INSTANCE;
    }

    private ForgeColorManager() {
    }

    @Override
    public void setupBlockColors(Consumer<IColorManager.IBlockColorSetter> configurator) {
        this.blockColorSetters.add(configurator);
    }

    @Override
    public void setupItemColors(Consumer<IColorManager.IItemColorSetter> configurator) {
        this.itemColorSetters.add(configurator);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockColorHandler(ColorHandlerEvent.Block event) {
        ForgeColorManager.getInstance().blockColorSetters.forEach(c -> c.accept((arg_0, arg_1) -> ((BlockColors)event.getBlockColors()).m_92589_(arg_0, arg_1)));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemColorHandler(ColorHandlerEvent.Item event) {
        ForgeColorManager.getInstance().itemColorSetters.forEach(c -> c.accept((arg_0, arg_1) -> ((ItemColors)event.getItemColors()).m_92689_(arg_0, arg_1)));
    }
}

