/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.events;

import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.logic.LeftClickInteractionHandler;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LeftClickEventHandler {
    @SubscribeEvent
    public static void onPlayerInteractLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ClickProcessingState result = LeftClickInteractionHandler.leftClickOnBlock(event.getPlayer(), event.getHand(), event.getItemStack(), event.getPos(), event.getFace(), event.isCanceled(), LeftClickEventHandler.mapResult(event.getUseItem()));
        if (result.shouldCancel()) {
            event.setCanceled(true);
        }
        event.setUseItem(LeftClickEventHandler.mapResult(result.getNextState()));
    }

    private static ClickProcessingState.ProcessingResult mapResult(Event.Result result) {
        return switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case Event.Result.DENY -> ClickProcessingState.ProcessingResult.DENY;
            case Event.Result.DEFAULT -> ClickProcessingState.ProcessingResult.DEFAULT;
            case Event.Result.ALLOW -> ClickProcessingState.ProcessingResult.ALLOW;
        };
    }

    private static Event.Result mapResult(ClickProcessingState.ProcessingResult processingResult) {
        return switch (processingResult) {
            default -> throw new IncompatibleClassChangeError();
            case ClickProcessingState.ProcessingResult.DENY -> Event.Result.DENY;
            case ClickProcessingState.ProcessingResult.DEFAULT -> Event.Result.DEFAULT;
            case ClickProcessingState.ProcessingResult.ALLOW -> Event.Result.ALLOW;
        };
    }
}

