/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.container;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import mod.chiselsandbits.recipe.modificationtable.ModificationTableRecipe;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModContainerTypes;
import mod.chiselsandbits.registrars.ModRecipeTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModificationTableContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPosCallable;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    private List<ModificationTableRecipe> recipes = Lists.newArrayList();
    private ItemStack inputItemStack = ItemStack.f_41583_;
    private long lastOnTake;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final Container inputInventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            ModificationTableContainer.this.m_6199_((Container)this);
            ModificationTableContainer.this.inventoryUpdateListener.run();
        }
    };
    private final ResultContainer inventory = new ResultContainer();

    public ModificationTableContainer(int windowIdIn, Inventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.f_39287_);
    }

    public ModificationTableContainer(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn) {
        super(ModContainerTypes.MODIFICATION_TABLE.get(), windowIdIn);
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.f_35978_.f_19853_;
        this.inputInventorySlot = this.m_38897_(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.m_38897_(new Slot((Container)this.inventory, 1, 143, 33){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player thePlayer, @NotNull ItemStack stack) {
                stack.m_41678_(thePlayer.f_19853_, thePlayer, stack.m_41613_());
                ModificationTableContainer.this.inventory.m_8015_(thePlayer);
                ItemStack itemstack = ModificationTableContainer.this.inputInventorySlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    ModificationTableContainer.this.updateRecipeResultSlot();
                }
                worldPosCallableIn.m_39292_((p_216954_1_, p_216954_2_) -> {
                    long l = p_216954_1_.m_46467_();
                    if (ModificationTableContainer.this.lastOnTake != l) {
                        p_216954_1_.m_5594_(null, p_216954_2_, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ModificationTableContainer.this.lastOnTake = l;
                    }
                });
                super.m_142406_(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 115 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 173));
        }
        this.m_38895_(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<ModificationTableRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputInventorySlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return ModificationTableContainer.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)ModBlocks.MODIFICATION_TABLE.get());
    }

    public boolean m_6366_(@NotNull Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_241818_1_) {
        return p_241818_1_ >= 0 && p_241818_1_ < this.recipes.size();
    }

    public void m_6199_(@NotNull Container inventoryIn) {
        ItemStack itemstack = this.inputInventorySlot.m_7993_();
        if (itemstack.m_41720_() != this.inputItemStack.m_41720_()) {
            this.inputItemStack = itemstack.m_41777_();
            this.updateAvailableRecipes(inventoryIn, itemstack);
        }
    }

    private void updateAvailableRecipes(Container inventoryIn, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.world.m_7465_().m_44056_(ModRecipeTypes.MODIFICATION_TABLE, inventoryIn, this.world);
            this.recipes.sort(Comparator.comparing(modificationTableRecipe -> Objects.requireNonNull(modificationTableRecipe.getOperation().getRegistryName()).toString()));
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.m_6501_())) {
            ModificationTableRecipe modificationTableRecipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.inventory.m_6029_((Recipe)modificationTableRecipe);
            this.outputInventorySlot.m_5852_(modificationTableRecipe.m_5874_(this.inputInventory));
        } else {
            this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return ModContainerTypes.MODIFICATION_TABLE.get();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean m_5882_(@NotNull ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.inventory && super.m_5882_(stack, slotIn);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (index == 1) {
                item.m_7836_(itemstack1, playerIn.f_19853_, playerIn);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.world.m_7465_().m_44015_(ModRecipeTypes.MODIFICATION_TABLE, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.world).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_8016_(1);
        this.worldPosCallable.m_39292_((p_217079_2_, p_217079_3_) -> this.m_150411_(playerIn, this.inputInventory));
    }
}

