/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face.model;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.chiselsandbits.client.model.baked.face.model.BaseModelReader;
import mod.chiselsandbits.utils.ModelUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public class ModelUVReader
extends BaseModelReader {
    private final float minU;
    private final float maxUMinusMin;
    private final float minV;
    private final float maxVMinusMin;
    private final float[] quadUVs = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private final List<PositionUVAndCorner> positionAndUVS = new ArrayList<PositionUVAndCorner>();
    private final int uCoord;
    private final int vCoord;
    private final Direction face;
    private float[] pos;
    private float[] uv;
    private int corners;

    public ModelUVReader(TextureAtlasSprite texture, int uFaceCoord, int vFaceCoord, Direction face) {
        this.minU = texture.m_118409_();
        this.maxUMinusMin = texture.m_118410_() - this.minU;
        this.minV = texture.m_118411_();
        this.maxVMinusMin = texture.m_118412_() - this.minV;
        this.uCoord = uFaceCoord;
        this.vCoord = vFaceCoord;
        this.face = face;
    }

    @Override
    public void put(int vertexIndex, int element, float ... data) {
        VertexFormat format = this.getVertexFormat();
        VertexFormatElement ele = (VertexFormatElement)format.m_86023_().get(element);
        if (ele.m_86048_() == VertexFormatElement.Usage.UV && ele.m_86049_() == 0) {
            this.uv = Arrays.copyOf(data, data.length);
        } else if (ele.m_86048_() == VertexFormatElement.Usage.POSITION) {
            this.pos = Arrays.copyOf(data, data.length);
        }
        if (element == format.m_86023_().size() - 1) {
            if (ModelUtil.isZero(this.pos[this.uCoord]) && ModelUtil.isZero(this.pos[this.vCoord])) {
                this.corners |= 1;
                this.quadUVs[0] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[1] = (this.uv[1] - this.minV) / this.maxVMinusMin;
                this.positionAndUVS.add(new PositionUVAndCorner(this.pos, new float[]{this.quadUVs[0], this.quadUVs[1]}, 1));
            } else if (ModelUtil.isZero(this.pos[this.uCoord]) && ModelUtil.isOne(this.pos[this.vCoord])) {
                this.corners |= 2;
                this.quadUVs[4] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[5] = (this.uv[1] - this.minV) / this.maxVMinusMin;
                this.positionAndUVS.add(new PositionUVAndCorner(this.pos, new float[]{this.quadUVs[4], this.quadUVs[5]}, 2));
            } else if (ModelUtil.isOne(this.pos[this.uCoord]) && ModelUtil.isZero(this.pos[this.vCoord])) {
                this.corners |= 4;
                this.quadUVs[2] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[3] = (this.uv[1] - this.minV) / this.maxVMinusMin;
                this.positionAndUVS.add(new PositionUVAndCorner(this.pos, new float[]{this.quadUVs[2], this.quadUVs[3]}, 4));
            } else if (ModelUtil.isOne(this.pos[this.uCoord]) && ModelUtil.isOne(this.pos[this.vCoord])) {
                this.corners |= 8;
                this.quadUVs[6] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[7] = (this.uv[1] - this.minV) / this.maxVMinusMin;
                this.positionAndUVS.add(new PositionUVAndCorner(this.pos, new float[]{this.quadUVs[6], this.quadUVs[7]}, 8));
            }
        }
    }

    public float[] getQuadUVs() {
        return this.quadUVs;
    }

    @Override
    public void onComplete() {
        int[][] selectorIndexes = new int[][]{{0, 1, 4, 5, 2, 3, 6, 7}, {4, 5, 0, 1, 6, 7, 2, 3}, {2, 3, 6, 7, 0, 1, 4, 5}, {0, 1, 4, 5, 2, 3, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {4, 5, 6, 7, 0, 1, 2, 3}};
        float[] data = Arrays.copyOf(this.quadUVs, 8);
        for (int i = 0; i < 8; ++i) {
            int n = selectorIndexes[this.face.m_122411_()][i];
        }
    }

    private record PositionUVAndCorner(float[] position, float[] uv, int corner) {
    }
}

