/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.logic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import mod.chiselsandbits.api.client.render.preview.placement.PlacementPreviewRenderMode;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.wireframe.IWireframeProvidingItem;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.placement.IPlacementPreviewProvidingItem;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.client.render.ChiseledBlockGhostRenderer;
import mod.chiselsandbits.client.render.ChiseledBlockWireframeRenderer;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultiStateBlockPreviewRenderHandler {
    public static void renderMultiStateBlockPreview(PoseStack poseStack) {
        boolean forceWireframe;
        boolean ignoreDepth;
        PlacementResult placementResult;
        BlockHitResult blockRayTraceResult;
        HitResult rayTraceResult = Minecraft.m_91087_().f_91077_;
        if (!(rayTraceResult instanceof BlockHitResult) || (blockRayTraceResult = (BlockHitResult)rayTraceResult).m_6662_() == HitResult.Type.MISS) {
            return;
        }
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        if (playerEntity == null || playerEntity.m_5833_()) {
            return;
        }
        ItemStack heldStack = ItemStackUtils.getMultiStateItemStackFromPlayer((Player)playerEntity);
        Item item = heldStack.m_41720_();
        if (!(item instanceof IWireframeProvidingItem)) {
            return;
        }
        IWireframeProvidingItem wireframeItem = (IWireframeProvidingItem)item;
        Vec3 targetedRenderPos = wireframeItem.getTargetedPosition(heldStack, (Player)playerEntity, blockRayTraceResult).m_82520_((double)0.001f, (double)0.001f, (double)0.001f);
        float bitSize = StateEntrySize.current().getSizePerBit();
        targetedRenderPos = targetedRenderPos.m_82492_(targetedRenderPos.f_82479_ % (double)bitSize + (double)(targetedRenderPos.f_82479_ < 0.0 ? bitSize : 0.0f), targetedRenderPos.f_82480_ % (double)bitSize + (double)(targetedRenderPos.f_82480_ < 0.0 ? bitSize : 0.0f), targetedRenderPos.f_82481_ % (double)bitSize + (double)(targetedRenderPos.f_82481_ < 0.0 ? bitSize : 0.0f));
        Item item2 = heldStack.m_41720_();
        if (item2 instanceof IPlacementPreviewProvidingItem) {
            IPlacementPreviewProvidingItem placementPreviewItem = (IPlacementPreviewProvidingItem)item2;
            placementResult = placementPreviewItem.getPlacementResult(heldStack, (Player)playerEntity, blockRayTraceResult);
            ignoreDepth = placementPreviewItem.ignoreDepthForPlacement(heldStack, placementResult);
            forceWireframe = false;
        } else {
            placementResult = PlacementResult.failure(wireframeItem.getWireFrameColor(heldStack, (Player)playerEntity, blockRayTraceResult));
            ignoreDepth = wireframeItem.ignoreDepth(heldStack);
            forceWireframe = true;
        }
        IClientConfiguration clientConfig = IClientConfiguration.getInstance();
        PlacementPreviewRenderMode success = clientConfig.getSuccessfulPlacementRenderMode().get();
        PlacementPreviewRenderMode failure = clientConfig.getFailedPlacementRenderMode().get();
        if (forceWireframe || placementResult.isSuccess() && success.isWireframe() || !placementResult.isSuccess() && failure.isWireframe() || !MultiStateBlockPreviewRenderHandler.renderGhost(poseStack, heldStack, targetedRenderPos, placementResult, success, failure, ignoreDepth)) {
            MultiStateBlockPreviewRenderHandler.renderWireFrame(poseStack, (Player)playerEntity, heldStack, wireframeItem, blockRayTraceResult, targetedRenderPos, placementResult.getColor(), ignoreDepth);
        }
    }

    private static void renderWireFrame(PoseStack poseStack, Player playerEntity, ItemStack heldStack, IWireframeProvidingItem wireframeItem, BlockHitResult blockRayTraceResult, Vec3 targetedRenderPos, Vector4f color, boolean ignoreDepth) {
        VoxelShape wireFrame = wireframeItem.getWireFrame(heldStack, playerEntity, blockRayTraceResult);
        ChiseledBlockWireframeRenderer.getInstance().renderShape(poseStack, wireFrame, targetedRenderPos, color, ignoreDepth);
    }

    private static boolean renderGhost(PoseStack poseStack, ItemStack heldStack, Vec3 targetedRenderPos, PlacementResult placementResult, PlacementPreviewRenderMode success, PlacementPreviewRenderMode failure, boolean ignoreDepth) {
        ItemStack renderStack;
        Item item = heldStack.m_41720_();
        if (item instanceof IPatternItem) {
            IPatternItem patternItem = (IPatternItem)item;
            IMultiStateItemStack multiSate = patternItem.createItemStack(heldStack);
            renderStack = multiSate.toBlockStack();
            if (renderStack.m_41619_()) {
                return false;
            }
        } else {
            renderStack = heldStack;
        }
        ChiseledBlockGhostRenderer.getInstance().renderGhost(poseStack, renderStack, targetedRenderPos, placementResult, success, failure, ignoreDepth);
        return true;
    }
}

