/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.inventory.bit;

import java.util.Map;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.item.bit.IBitItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IBitInventory {
    default public boolean canExtractOne(BlockInformation blockInformation) {
        return this.canExtract(blockInformation, 1);
    }

    public boolean canExtract(BlockInformation var1, int var2);

    public int getMaxExtractAmount(BlockInformation var1);

    default public void extractOne(BlockInformation blockInformation) throws IllegalArgumentException {
        this.extract(blockInformation, 1);
    }

    public void extract(BlockInformation var1, int var2) throws IllegalArgumentException;

    default public boolean canInsertOne(BlockInformation blockInformation) {
        return this.canInsert(blockInformation, 1);
    }

    public boolean canInsert(BlockInformation var1, int var2);

    public int getMaxInsertAmount(BlockInformation var1);

    default public void insertOne(BlockInformation blockInformation) throws IllegalArgumentException {
        this.insert(blockInformation, 1);
    }

    public void insert(BlockInformation var1, int var2) throws IllegalArgumentException;

    default public void insertOrDiscard(BlockInformation blockInformation, int count) {
        this.insert(blockInformation, Math.min(this.getMaxInsertAmount(blockInformation), count));
    }

    public boolean isEmpty();

    default public ItemStack insert(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IBitItem)) {
            return stack;
        }
        IBitItem bitItem = (IBitItem)item;
        BlockInformation blockInformation = bitItem.getBlockInformation(stack);
        int maxToInsertCount = this.getMaxInsertAmount(blockInformation);
        int maxToInsertFromStack = Math.min(stack.m_41613_(), maxToInsertCount);
        int maxRemainingOnStack = stack.m_41613_() - maxToInsertCount;
        this.insert(blockInformation, maxToInsertFromStack);
        ItemStack resultStack = stack.m_41777_();
        resultStack.m_41764_(maxRemainingOnStack);
        return resultStack;
    }

    public Map<BlockInformation, Integer> getContainedStates();
}

