/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;

public class SimpleMaxSizedCache<K, V> {
    private final LinkedHashMap<K, V> cache = new LinkedHashMap();
    private long maxSize;

    public SimpleMaxSizedCache(long maxSize) {
        this.maxSize = maxSize;
    }

    private void evictFromCacheIfNeeded() {
        if ((long)this.cache.size() == this.maxSize) {
            this.cache.remove(this.cache.keySet().iterator().next());
        }
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public void put(K key, V value) {
        if (!this.cache.containsKey(key)) {
            this.evictFromCacheIfNeeded();
        }
        this.cache.put(key, value);
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    public Collection<V> values() {
        return this.cache.values();
    }

    public void changeMaxSize(long newSize) {
        if (this.maxSize != newSize) {
            this.clear();
            this.maxSize = newSize;
        }
    }

    public void clear() {
        this.cache.clear();
    }
}

