/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.function.Supplier;
import mod.chiselsandbits.core.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ChuckRenderCacheWrapper
implements IBlockDisplayReader {
    private final ChunkRenderCache chunkRenderCache;

    public ChuckRenderCacheWrapper(ChunkRenderCache chunkRenderCache) {
        this.chunkRenderCache = chunkRenderCache;
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return this.chunkRenderCache.func_230487_a_(p_230487_1_, p_230487_2_);
    }

    public WorldLightManager func_225524_e_() {
        return this.chunkRenderCache.func_225524_e_();
    }

    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return this.whenPosValidOrElse(blockPosIn, () -> this.chunkRenderCache.func_225525_a_(blockPosIn, colorResolverIn), () -> 0);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.whenPosValidOrElse(pos, () -> this.chunkRenderCache.func_175625_s(pos), () -> null);
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.whenPosValidOrElse(pos, () -> this.chunkRenderCache.func_180495_p(pos), () -> ((Block)Blocks.field_150350_a).func_176223_P());
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.whenPosValidOrElse(pos, () -> this.chunkRenderCache.func_204610_c(pos), () -> ((Fluid)Fluids.field_204541_a).func_207188_f());
    }

    private boolean falseWhenInvalidPos(BlockPos pos, Supplier<Boolean> validSupplier) {
        return this.whenPosValidOrElse(pos, validSupplier, () -> false);
    }

    private <T> T whenPosValidOrElse(BlockPos pos, Supplier<T> validSupplier, Supplier<T> invalidSupplier) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
            return invalidSupplier.get();
        }
        try {
            return validSupplier.get();
        }
        catch (Exception e) {
            Log.logError("Failed to process cached wrapped info for: " + pos, e);
            return invalidSupplier.get();
        }
    }
}

