/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.helpers;

import java.util.Arrays;
import mod.chiselsandbits.render.helpers.BaseModelReader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;

public class ModelQuadReader
extends BaseModelReader {
    int minX = 16;
    int minY = 16;
    int minZ = 16;
    int maxX = 0;
    int maxY = 0;
    int maxZ = 0;
    int u;
    int v;
    int[][] pos_uv = new int[4][5];
    TextureAtlasSprite sprite;
    String texture;
    Direction face;
    Direction cull;
    float[] pos;
    float[] uv;
    int index = 0;

    public ModelQuadReader(String textureName, TextureAtlasSprite texture, Direction face, Direction cull) {
        this.sprite = texture;
        this.texture = textureName;
        this.face = face;
        this.cull = cull;
    }

    public void put(int element, float ... data) {
        VertexFormat format = this.getVertexFormat();
        VertexFormatElement ele = (VertexFormatElement)format.func_227894_c_().get(element);
        if (ele.func_177375_c() == VertexFormatElement.Usage.UV && ele.func_177369_e() != 1) {
            this.uv = Arrays.copyOf(data, data.length);
        } else if (ele.func_177375_c() == VertexFormatElement.Usage.POSITION) {
            this.pos = Arrays.copyOf(data, data.length);
        }
        if (element == format.func_227894_c_().size() - 1) {
            this.pos_uv[this.index][0] = Math.round(this.pos[0] * 16.0f);
            this.pos_uv[this.index][1] = Math.round(this.pos[1] * 16.0f);
            this.pos_uv[this.index][2] = Math.round(this.pos[2] * 16.0f);
            this.pos_uv[this.index][3] = Math.round((this.uv[0] - this.sprite.func_94209_e()) / (this.sprite.func_94212_f() - this.sprite.func_94209_e()) * 16.0f);
            this.pos_uv[this.index][4] = Math.round((this.uv[1] - this.sprite.func_94206_g()) / (this.sprite.func_94210_h() - this.sprite.func_94206_g()) * 16.0f);
            this.minX = Math.min(this.minX, this.pos_uv[this.index][0]);
            this.minY = Math.min(this.minY, this.pos_uv[this.index][1]);
            this.minZ = Math.min(this.minZ, this.pos_uv[this.index][2]);
            this.maxX = Math.max(this.maxX, this.pos_uv[this.index][0]);
            this.maxY = Math.max(this.maxY, this.pos_uv[this.index][1]);
            this.maxZ = Math.max(this.maxZ, this.pos_uv[this.index][2]);
            ++this.index;
        }
    }

    public String toString(Direction faceQuad) {
        int U1 = 0;
        int V1 = 16;
        int U2 = 16;
        int V2 = 0;
        for (int idx = 0; idx < 4; ++idx) {
            if (this.matches(this.minX, this.minY, this.minZ, this.pos_uv[idx])) {
                U1 = this.pos_uv[idx][3];
                V2 = this.pos_uv[idx][4];
                continue;
            }
            if (!this.matches(this.maxX, this.maxY, this.maxZ, this.pos_uv[idx])) continue;
            U2 = this.pos_uv[idx][3];
            V1 = this.pos_uv[idx][4];
        }
        if (faceQuad.func_176736_b() > 1) {
            int tempU = U1;
            U1 = U2;
            U2 = tempU;
        } else if (faceQuad == Direction.UP) {
            int tempV = V1;
            V1 = V2;
            V2 = tempV;
        }
        if (this.cull == null) {
            return "{ \"from\": [" + this.minX + "," + this.minY + "," + this.minZ + "], \"to\": [" + this.maxX + "," + this.maxY + "," + this.maxZ + "], \"faces\": { \"" + this.face.func_176610_l() + "\":  { \"uv\": [" + U1 + "," + V1 + "," + U2 + "," + V2 + "], \"texture\": \"" + this.texture + "\" } } },\n";
        }
        return "{ \"from\": [" + this.minX + "," + this.minY + "," + this.minZ + "], \"to\": [" + this.maxX + "," + this.maxY + "," + this.maxZ + "], \"faces\": { \"" + this.face.func_176610_l() + "\":  { \"uv\": [" + U1 + "," + V1 + "," + U2 + "," + V2 + "], \"texture\": \"" + this.texture + "\", \"cullface\": \"" + this.cull.func_176610_l() + "\" } } },\n";
    }

    private boolean matches(int x, int y, int z, int[] v) {
        return v[0] == x && v[1] == y && v[2] == z;
    }
}

