/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.bit.BitItemSmartModel;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.patterns.PrintSmartModel;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.RegistryObject;

public class SmartModelManager {
    private static final SmartModelManager INSTANCE = new SmartModelManager();
    private boolean setup = false;
    private final HashMap<ResourceLocation, IBakedModel> models = new HashMap();
    private final List<ModelResourceLocation> res = new ArrayList<ModelResourceLocation>();
    private final List<ICacheClearable> clearable = new ArrayList<ICacheClearable>();

    public static SmartModelManager getInstance() {
        return INSTANCE;
    }

    private SmartModelManager() {
    }

    private void setup() {
        if (this.setup) {
            return;
        }
        this.setup = true;
        ChiseledBlockSmartModel smartModel = new ChiseledBlockSmartModel();
        this.add(Constants.DataGenerator.CHISELED_BLOCK_MODEL, smartModel);
        for (RegistryObject<BlockChiseled> bc : ModBlocks.getMaterialToBlockConversions().values()) {
            this.add(new ResourceLocation("chiselsandbits", ((BlockChiseled)bc.get()).name), smartModel);
        }
        ChiselsAndBits.getInstance().addClearable(smartModel);
        this.add(new ResourceLocation("chiselsandbits", "models/item/block_bit"), new BitItemSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "models/item/positiveprint_written_preview"), new PrintSmartModel("positiveprint", (IPatternItem)ModItems.ITEM_POSITIVE_PRINT_WRITTEN.get()));
        this.add(new ResourceLocation("chiselsandbits", "models/item/negativeprint_written_preview"), new PrintSmartModel("negativeprint", (IPatternItem)ModItems.ITEM_NEGATIVE_PRINT_WRITTEN.get()));
        this.add(new ResourceLocation("chiselsandbits", "models/item/mirrorprint_written_preview"), new PrintSmartModel("mirrorprint", (IPatternItem)ModItems.ITEM_MIRROR_PRINT_WRITTEN.get()));
    }

    private void add(ResourceLocation modelLocation, IBakedModel modelGen) {
        ResourceLocation second = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a().substring(1 + modelLocation.func_110623_a().lastIndexOf(47)));
        if (modelGen instanceof ICacheClearable) {
            this.clearable.add((ICacheClearable)modelGen);
        }
        this.res.add(new ModelResourceLocation(modelLocation, "normal"));
        this.res.add(new ModelResourceLocation(second, "normal"));
        this.res.add(new ModelResourceLocation(modelLocation, "inventory"));
        this.res.add(new ModelResourceLocation(second, "inventory"));
        this.res.add(new ModelResourceLocation(modelLocation, "multipart"));
        this.res.add(new ModelResourceLocation(second, "multipart"));
        this.models.put(modelLocation, modelGen);
        this.models.put(second, modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(modelLocation, "normal"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(second, "normal"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(modelLocation, "inventory"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(second, "inventory"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(modelLocation, "multipart"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(second, "multipart"), modelGen);
    }

    public void textureStichEvent(TextureStitchEvent.Post stitch) {
        ChiselsAndBits.getInstance().clearCache();
    }

    public void onModelBakeEvent(ModelBakeEvent event) {
        this.setup();
        for (ICacheClearable c : this.clearable) {
            c.clearCache();
        }
        for (ModelResourceLocation rl : this.res) {
            event.getModelRegistry().put(rl, this.getModel((ResourceLocation)rl));
        }
    }

    private IBakedModel getModel(ResourceLocation modelLocation) {
        try {
            return this.models.get(modelLocation);
        }
        catch (Exception e) {
            throw new RuntimeException("The Model: " + modelLocation.toString() + " was not available was requested.");
        }
    }

    private static final class Setup {
        private Setup() {
        }
    }
}

