/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registry;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import mod.chiselsandbits.bitstorage.BlockBitStorage;
import mod.chiselsandbits.bitstorage.ItemBlockBitStorage;
import mod.chiselsandbits.bitstorage.ItemStackSpecialRendererBitStorage;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.MaterialType;
import mod.chiselsandbits.printer.ChiselPrinterBlock;
import mod.chiselsandbits.registry.ModItemGroups;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class ModBlocks {
    private static final DeferredRegister<Block> BLOCK_REGISTRAR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chiselsandbits");
    private static final DeferredRegister<Item> ITEM_REGISTRAR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"chiselsandbits");
    public static final Map<Material, RegistryObject<BlockChiseled>> MATERIAL_TO_BLOCK_CONVERSIONS = Maps.newHashMap();
    public static final Map<Material, RegistryObject<ItemBlockChiseled>> MATERIAL_TO_ITEM_CONVERSIONS = Maps.newHashMap();
    public static final RegistryObject<BlockBitStorage> BIT_STORAGE_BLOCK = BLOCK_REGISTRAR.register("bit_storage", () -> new BlockBitStorage(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 6.0f).harvestTool(ToolType.AXE).harvestLevel(1).func_235861_h_().func_208770_d().func_226896_b_().func_235827_a_((p_test_1_, p_test_2_, p_test_3_, p_test_4_) -> false).func_235828_a_((p_test_1_, p_test_2_, p_test_3_) -> false).func_235842_b_((p_test_1_, p_test_2_, p_test_3_) -> false).func_235847_c_((p_test_1_, p_test_2_, p_test_3_) -> false)));
    public static final RegistryObject<BlockItem> BIT_STORAGE_BLOCK_ITEM = ITEM_REGISTRAR.register("bit_storage", () -> new ItemBlockBitStorage((Block)BIT_STORAGE_BLOCK.get(), new Item.Properties().func_200916_a(ModItemGroups.CHISELS_AND_BITS).setISTER(() -> ItemStackSpecialRendererBitStorage::new)));
    public static final RegistryObject<ChiselPrinterBlock> CHISEL_PRINTER_BLOCK = BLOCK_REGISTRAR.register("chisel_printer", () -> new ChiselPrinterBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 6.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_226896_b_().func_235828_a_((p_test_1_, p_test_2_, p_test_3_) -> false).func_235847_c_((p_test_1_, p_test_2_, p_test_3_) -> false)));
    public static final RegistryObject<BlockItem> CHISEL_PRINTER_ITEM = ITEM_REGISTRAR.register("chisel_printer", () -> new BlockItem((Block)CHISEL_PRINTER_BLOCK.get(), new Item.Properties().func_200916_a(ModItemGroups.CHISELS_AND_BITS)));
    public static final MaterialType[] VALID_CHISEL_MATERIALS = new MaterialType[]{new MaterialType("wood", Material.field_151575_d), new MaterialType("rock", Material.field_151576_e), new MaterialType("iron", Material.field_151573_f), new MaterialType("cloth", Material.field_151593_r), new MaterialType("ice", Material.field_151588_w), new MaterialType("packed_ice", Material.field_151598_x), new MaterialType("clay", Material.field_151571_B), new MaterialType("glass", Material.field_151592_s), new MaterialType("sand", Material.field_151595_p), new MaterialType("ground", Material.field_151578_c), new MaterialType("grass", Material.field_151578_c), new MaterialType("snow", Material.field_151596_z), new MaterialType("fluid", Material.field_151586_h), new MaterialType("leaves", Material.field_151584_j)};

    private ModBlocks() {
        throw new IllegalStateException("Tried to initialize: ModBlocks but this is a Utility class.");
    }

    public static void onModConstruction() {
        BLOCK_REGISTRAR.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEM_REGISTRAR.register(FMLJavaModLoadingContext.get().getModEventBus());
        Arrays.stream(VALID_CHISEL_MATERIALS).forEach(materialType -> {
            MATERIAL_TO_BLOCK_CONVERSIONS.put(materialType.getType(), (RegistryObject<BlockChiseled>)BLOCK_REGISTRAR.register("chiseled" + materialType.getName(), () -> new BlockChiseled("chiseled_" + materialType.getName(), AbstractBlock.Properties.func_200945_a((Material)materialType.getType()).func_200948_a(1.5f, 6.0f).func_235847_c_((p_test_1_, p_test_2_, p_test_3_) -> false).func_235828_a_((p_test_1_, p_test_2_, p_test_3_) -> false).func_226896_b_())));
            MATERIAL_TO_ITEM_CONVERSIONS.put(materialType.getType(), (RegistryObject<ItemBlockChiseled>)ITEM_REGISTRAR.register("chiseled" + materialType.getName(), () -> new ItemBlockChiseled((Block)MATERIAL_TO_BLOCK_CONVERSIONS.get(materialType.getType()).get(), new Item.Properties())));
        });
    }

    public static Map<Material, RegistryObject<ItemBlockChiseled>> getMaterialToItemConversions() {
        return MATERIAL_TO_ITEM_CONVERSIONS;
    }

    public static Map<Material, RegistryObject<BlockChiseled>> getMaterialToBlockConversions() {
        return MATERIAL_TO_BLOCK_CONVERSIONS;
    }

    public static MaterialType[] getValidChiselMaterials() {
        return VALID_CHISEL_MATERIALS;
    }

    @Nullable
    public static BlockState getChiseledDefaultState() {
        Iterator<RegistryObject<BlockChiseled>> blockIterator = ModBlocks.getMaterialToBlockConversions().values().iterator();
        if (blockIterator.hasNext()) {
            return ((BlockChiseled)blockIterator.next().get()).func_176223_P();
        }
        return null;
    }

    public static BlockChiseled convertGivenStateToChiseledBlock(BlockState state) {
        Fluid f = BlockBitInfo.getFluidFromBlock(state.func_177230_c());
        return ModBlocks.convertGivenMaterialToChiseledBlock(f != null ? Material.field_151586_h : state.func_185904_a());
    }

    public static BlockChiseled convertGivenMaterialToChiseledBlock(Material material) {
        RegistryObject<BlockChiseled> materialBlock = ModBlocks.getMaterialToBlockConversions().get(material);
        return materialBlock != null ? (BlockChiseled)materialBlock.get() : ModBlocks.convertGivenMaterialToChiseledBlock(Material.field_151576_e);
    }

    public static RegistryObject<BlockChiseled> convertGivenStateToChiseledRegistryBlock(BlockState state) {
        Fluid f = BlockBitInfo.getFluidFromBlock(state.func_177230_c());
        return ModBlocks.convertGivenMaterialToChiseledRegistryBlock(f != null ? Material.field_151586_h : state.func_185904_a());
    }

    public static RegistryObject<BlockChiseled> convertGivenMaterialToChiseledRegistryBlock(Material material) {
        RegistryObject<BlockChiseled> materialBlock = ModBlocks.getMaterialToBlockConversions().get(material);
        return materialBlock != null ? materialBlock : ModBlocks.convertGivenMaterialToChiseledRegistryBlock(Material.field_151576_e);
    }

    public static boolean convertMaterialTo(Material source, Material target) {
        RegistryObject<BlockChiseled> sourceRegisteredObject = ModBlocks.convertGivenMaterialToChiseledRegistryBlock(source);
        return ModBlocks.getMaterialToBlockConversions().put(target, sourceRegisteredObject) != null;
    }
}

